/*
 * Decompiled with CFR 0.152.
 */
package tihwin;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.AbstractDocument;
import tihwin.AwesomeMediator;
import tihwin.FilesHelper;
import tihwin.ScaleUi;
import tihwin.Settings;
import tihwin.UpdateUlTableUi;
import tihwin.cd.ISO9660;
import tihwin.ui.FilesDropListener;
import tihwin.ui.IsoFileFilter;
import tihwin.ui.LanguageComboBox;
import tihwin.ui.TitleFieldFilter;
import tihwin.ui.TwButtonsActionListener;
import tihwin.ui.UiUpdater;
import tihwin.ui.model.LocaleHolder;
import tihwin.ul.UlConfiguration;
import tihwin.ul.UlMaker;

public class MainAppUi
extends JFrame {
    private JPanel mainPanel;
    private JButton diskImageSelectBtn;
    private JButton destinationSelectBtn;
    private JButton convertBtn;
    private JLabel diskImageNameLbl;
    private JLabel statusLbl;
    private JProgressBar progressBar;
    private JPanel statusJPanel;
    private JLabel destinationDirectoryLbl;
    private JTextField titleField;
    private JRadioButton CDRadioButton;
    private JRadioButton DVDRadioButton;
    private JButton ulCfgBtn;
    private JComboBox<LocaleHolder> ulLangComboBox;
    private JLabel diskImageRoLbl;
    private JLabel titleRoLbl;
    private JLabel ulDestinationRoLbl;
    private JButton zoomInBtn;
    private JButton zoomOutBtn;
    private ResourceBundle resourceBundle;
    private List<Component> components;
    private String recentRomLocation;
    private File diskImage;
    private String publisherTitle;
    private boolean doWeConvertAnythingNow = false;
    private Thread splitThread;
    private static Method $$$cachedGetBundleMethod$$$ = null;

    public MainAppUi(String appName) {
        super(appName);
        this.$$$setupUI$$$();
        this.resourceBundle = ResourceBundle.getBundle("locale");
        AwesomeMediator.setMainUi(this);
        this.mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(107, 128), "zoomIn");
        this.mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke(109, 128), "zoomOut");
        AbstractAction zoom = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("+".equals(e.getActionCommand())) {
                    MainAppUi.this.zoomIn();
                } else {
                    MainAppUi.this.zoomOut();
                }
            }
        };
        this.mainPanel.getActionMap().put("zoomIn", zoom);
        this.mainPanel.getActionMap().put("zoomOut", zoom);
        this.setLocationRelativeTo(null);
        new FilesDropListener(this.mainPanel);
        this.setContentPane(this.mainPanel);
        this.statusJPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.darkGray));
        this.convertBtn.setEnabled(false);
        this.diskImageSelectBtn.addActionListener(actionEvent -> this.diskImageSelectEventHandler());
        this.destinationSelectBtn.addActionListener(actionEvent -> this.destinationSelectEventHandler());
        this.convertBtn.addActionListener(actionEvent -> this.convertButtonAction());
        this.ulCfgBtn.addActionListener(actionEvent -> this.ulConfigButtonAction());
        this.zoomInBtn.addActionListener(actionEvent -> this.zoomIn());
        this.zoomOutBtn.addActionListener(actionEvent -> this.zoomOut());
        ((AbstractDocument)this.titleField.getDocument()).setDocumentFilter(new TitleFieldFilter());
        if (Settings.INSTANCE.getDvdSelected()) {
            this.DVDRadioButton.setSelected(true);
        } else {
            this.CDRadioButton.setSelected(true);
        }
        this.recentRomLocation = Settings.INSTANCE.getRomLocation();
        this.destinationDirectoryLbl.setText(FilesHelper.getRealFolder(Settings.INSTANCE.getDestination()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Settings.INSTANCE.setRomLocation(MainAppUi.this.recentRomLocation);
                Settings.INSTANCE.setDestination(MainAppUi.this.destinationDirectoryLbl.getText());
                Settings.INSTANCE.setDvdSelected(MainAppUi.this.DVDRadioButton.isSelected());
                Settings.INSTANCE.setLocale(((LocaleHolder)MainAppUi.this.ulLangComboBox.getSelectedItem()).getLocaleCode());
                Settings.INSTANCE.setScaleFactor(AwesomeMediator.getScaleValue());
            }
        });
        CompoundBorder fitMoreTextOnButtonBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diskImageSelectBtn.setBorder(fitMoreTextOnButtonBorder);
        this.destinationSelectBtn.setBorder(fitMoreTextOnButtonBorder);
        this.ulCfgBtn.setBorder(fitMoreTextOnButtonBorder);
        this.diskImageSelectBtn.addMouseListener(new TwButtonsActionListener());
        this.destinationSelectBtn.addMouseListener(new TwButtonsActionListener());
        this.titleField.setBorder(new LineBorder(Color.lightGray));
        this.applyScaling();
    }

    private void applyScaling() {
        this.components = Arrays.stream(this.mainPanel.getComponents()).collect(Collectors.toList());
        this.components.add(this.statusLbl);
        this.components.add(this.ulLangComboBox);
        ScaleUi.applyInitialScale(this.components);
    }

    private void zoomIn() {
        ScaleUi.increaseScale(this.components);
        this.pack();
    }

    private void zoomOut() {
        ScaleUi.decreaseScale(this.components);
        this.pack();
    }

    private void diskImageSelectEventHandler() {
        JFileChooser fileChooser = new JFileChooser(FilesHelper.getRealFolder(this.recentRomLocation));
        fileChooser.setDialogTitle(this.resourceBundle.getString("SelectDiskImageText"));
        fileChooser.setFileFilter(new IsoFileFilter());
        if (fileChooser.showOpenDialog(null) == 0) {
            this.setDiskImageFile(fileChooser.getSelectedFile());
        }
    }

    public void setDiskImageFile(File imageFile) {
        try {
            this.recentRomLocation = imageFile.getParent();
            ISO9660 iso9660 = new ISO9660(imageFile);
            this.publisherTitle = iso9660.getTitle();
            this.diskImageNameLbl.setText(imageFile.getName());
            this.convertBtn.setEnabled(true);
            this.statusLbl.setText(imageFile.getAbsolutePath());
            this.diskImage = imageFile;
            this.setProposedTitle();
        }
        catch (Exception e) {
            this.statusLbl.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    private void setProposedTitle() {
        String proposedName = this.diskImage.getName().replaceAll("(\\..*)|(\\[.*)", "").trim();
        if (proposedName.length() > 31) {
            proposedName = proposedName.substring(0, 31);
        }
        if (proposedName.isEmpty()) {
            proposedName = "My favorite game";
        }
        this.titleField.setText(proposedName);
    }

    private void destinationSelectEventHandler() {
        JFileChooser fileChooser = new JFileChooser(FilesHelper.getRealFolder(this.destinationDirectoryLbl.getText()));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(this.resourceBundle.getString("SetDestinationDirectoryText"));
        if (fileChooser.showOpenDialog(null) == 0) {
            this.setDestinationDir(fileChooser.getSelectedFile());
        }
    }

    public void setDestinationDir(File folder) {
        this.destinationDirectoryLbl.setText(folder.getAbsolutePath());
    }

    private void convertButtonAction() {
        try {
            if (this.doWeConvertAnythingNow) {
                this.splitThread.interrupt();
                this.convertBtn.setEnabled(false);
                return;
            }
            if (this.titleField.getText().isEmpty()) {
                this.setProposedTitle();
                return;
            }
            String userTitle = this.titleField.getText();
            byte chunksCount = (byte)(this.diskImage.length() / 0x40000000L);
            if (this.diskImage.length() % 0x40000000L > 0L) {
                chunksCount = (byte)(chunksCount + 1);
            }
            UlConfiguration ulConfiguration = new UlConfiguration(userTitle, this.publisherTitle, chunksCount, this.DVDRadioButton.isSelected());
            UlMaker ulMaker = new UlMaker(this.diskImage, this.destinationDirectoryLbl.getText(), ulConfiguration, new UiUpdater(this.progressBar, this.statusLbl));
            this.statusLbl.setText(this.resourceBundle.getString("InProgressText"));
            this.splitThread = new Thread(ulMaker);
            this.splitThread.start();
            this.doWeConvertAnythingNow = true;
            this.convertBtn.setText(this.resourceBundle.getString("AbortText"));
        }
        catch (Exception e) {
            this.statusLbl.setText(e.getMessage());
        }
    }

    public void notifySplitFinished() {
        this.doWeConvertAnythingNow = false;
        this.convertBtn.setEnabled(true);
        this.convertBtn.setText(this.resourceBundle.getString("ConvertBtn"));
    }

    private void ulConfigButtonAction() {
        new UpdateUlTableUi(this.destinationDirectoryLbl.getText());
    }

    private void onLanguageChanged() {
        Locale newLocale = ((LocaleHolder)this.ulLangComboBox.getSelectedItem()).getLocale();
        Locale.setDefault(newLocale);
        this.resourceBundle = ResourceBundle.getBundle("locale");
        this.diskImageSelectBtn.setText(this.resourceBundle.getString("SelectBtn"));
        this.destinationSelectBtn.setText(this.resourceBundle.getString("SelectBtn"));
        if (this.doWeConvertAnythingNow) {
            this.convertBtn.setText(this.resourceBundle.getString("AbortText"));
            this.statusLbl.setText(this.resourceBundle.getString("InProgressText"));
        } else {
            this.convertBtn.setText(this.resourceBundle.getString("ConvertBtn"));
        }
        this.diskImageRoLbl.setText(this.resourceBundle.getString("DiskImageLbl"));
        this.titleRoLbl.setText(this.resourceBundle.getString("TitleLbl"));
        this.ulDestinationRoLbl.setText(this.resourceBundle.getString("ulDestinationLbl"));
        this.CDRadioButton.setText(this.resourceBundle.getString("CD"));
        this.DVDRadioButton.setText(this.resourceBundle.getString("DVD"));
        this.ulCfgBtn.setText(this.resourceBundle.getString("editUlCfgBtn"));
    }

    private void createUIComponents() {
        this.ulLangComboBox = new LanguageComboBox();
        this.ulLangComboBox.addActionListener(e -> this.onLanguageChanged());
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new FormLayout("fill:p:noGrow,left:4dlu:noGrow,fill:p:noGrow,left:4dlu:noGrow,fill:p:noGrow,fill:max(d;4px):noGrow,fill:d:grow,left:4dlu:noGrow,fill:p:grow(0.2)", "center:max(d;4px):noGrow,top:m:grow(1.1),top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        this.diskImageSelectBtn = new JButton();
        this.diskImageSelectBtn.setBackground(new Color(-2034433));
        this.$$$loadButtonText$$$(this.diskImageSelectBtn, this.$$$getMessageFromBundle$$$("locale", "SelectBtn"));
        CellConstraints cc = new CellConstraints();
        this.mainPanel.add((Component)this.diskImageSelectBtn, new CellConstraints(1, 4, 3, 1, CellConstraints.DEFAULT, CellConstraints.CENTER, new Insets(0, 5, 0, 0)));
        this.titleField = new JTextField();
        this.mainPanel.add((Component)this.titleField, new CellConstraints(7, 6, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        this.destinationDirectoryLbl = new JLabel();
        this.destinationDirectoryLbl.setText("");
        this.mainPanel.add((Component)this.destinationDirectoryLbl, cc.xyw(7, 8, 3));
        this.diskImageNameLbl = new JLabel();
        this.diskImageNameLbl.setText("");
        this.mainPanel.add((Component)this.diskImageNameLbl, cc.xy(7, 4));
        this.destinationSelectBtn = new JButton();
        this.destinationSelectBtn.setBackground(new Color(-2034433));
        this.$$$loadButtonText$$$(this.destinationSelectBtn, this.$$$getMessageFromBundle$$$("locale", "SelectBtn"));
        this.mainPanel.add((Component)this.destinationSelectBtn, new CellConstraints(1, 8, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 5, 0, 0)));
        this.ulDestinationRoLbl = new JLabel();
        this.$$$loadLabelText$$$(this.ulDestinationRoLbl, this.$$$getMessageFromBundle$$$("locale", "ulDestinationLbl"));
        this.mainPanel.add((Component)this.ulDestinationRoLbl, cc.xy(5, 8));
        this.diskImageRoLbl = new JLabel();
        this.$$$loadLabelText$$$(this.diskImageRoLbl, this.$$$getMessageFromBundle$$$("locale", "DiskImageLbl"));
        this.mainPanel.add((Component)this.diskImageRoLbl, cc.xy(5, 4));
        this.titleRoLbl = new JLabel();
        this.$$$loadLabelText$$$(this.titleRoLbl, this.$$$getMessageFromBundle$$$("locale", "TitleLbl"));
        this.mainPanel.add((Component)this.titleRoLbl, cc.xy(5, 6));
        this.CDRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(this.CDRadioButton, this.$$$getMessageFromBundle$$$("locale", "CD"));
        this.mainPanel.add((Component)this.CDRadioButton, cc.xy(1, 6));
        this.DVDRadioButton = new JRadioButton();
        this.DVDRadioButton.setSelected(true);
        this.$$$loadButtonText$$$(this.DVDRadioButton, this.$$$getMessageFromBundle$$$("locale", "DVD"));
        this.mainPanel.add((Component)this.DVDRadioButton, cc.xy(3, 6));
        this.convertBtn = new JButton();
        this.convertBtn.setBackground(new Color(-2034433));
        this.$$$loadButtonText$$$(this.convertBtn, this.$$$getMessageFromBundle$$$("locale", "ConvertBtn"));
        this.mainPanel.add((Component)this.convertBtn, new CellConstraints(1, 10, 9, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 5, 0, 5)));
        this.progressBar = new JProgressBar();
        this.progressBar.setBorderPainted(false);
        this.progressBar.setForeground(new Color(-26368));
        this.progressBar.setIndeterminate(false);
        this.mainPanel.add((Component)this.progressBar, cc.xyw(1, 12, 9, CellConstraints.FILL, CellConstraints.TOP));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.setBackground(new Color(-9251843));
        this.mainPanel.add((Component)panel1, cc.xyw(1, 1, 9));
        JLabel label1 = new JLabel();
        label1.setIcon(new ImageIcon(this.getClass().getResource("/banner.png")));
        label1.setText("");
        panel1.add((Component)label1, new GridConstraints(0, 0, 1, 1, 0, 0, 5, 0, null, null, null, 0, false));
        this.ulLangComboBox.setBackground(new Color(-9251843));
        this.ulLangComboBox.setForeground(new Color(-1));
        this.ulLangComboBox.putClientProperty("html.disable", Boolean.FALSE);
        panel1.add(this.ulLangComboBox, new GridConstraints(0, 1, 1, 1, 9, 1, 2, 0, null, null, null, 1, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(0, 5, 5));
        panel2.setAlignmentX(0.0f);
        panel2.setAlignmentY(0.0f);
        panel2.setFocusable(false);
        panel2.setOpaque(false);
        panel1.add((Component)panel2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null, 0, false));
        this.zoomInBtn = new JButton();
        this.zoomInBtn.setAlignmentY(0.0f);
        this.zoomInBtn.setBorderPainted(false);
        this.zoomInBtn.setContentAreaFilled(false);
        this.zoomInBtn.setFocusPainted(true);
        this.zoomInBtn.setIcon(new ImageIcon(this.getClass().getResource("/zoom-in.png")));
        this.zoomInBtn.setIconTextGap(0);
        this.zoomInBtn.setOpaque(false);
        this.zoomInBtn.setPreferredSize(new Dimension(25, 25));
        panel2.add(this.zoomInBtn);
        this.zoomOutBtn = new JButton();
        this.zoomOutBtn.setAlignmentY(0.0f);
        this.zoomOutBtn.setBorderPainted(false);
        this.zoomOutBtn.setContentAreaFilled(false);
        this.zoomOutBtn.setFocusPainted(true);
        this.zoomOutBtn.setForeground(new Color(-9251843));
        this.zoomOutBtn.setIcon(new ImageIcon(this.getClass().getResource("/zoom-out.png")));
        this.zoomOutBtn.setIconTextGap(0);
        this.zoomOutBtn.setOpaque(false);
        this.zoomOutBtn.setPreferredSize(new Dimension(25, 25));
        panel2.add(this.zoomOutBtn);
        this.ulCfgBtn = new JButton();
        this.ulCfgBtn.setBackground(new Color(-2031648));
        this.$$$loadButtonText$$$(this.ulCfgBtn, this.$$$getMessageFromBundle$$$("locale", "editUlCfgBtn"));
        this.mainPanel.add((Component)this.ulCfgBtn, new CellConstraints(9, 4, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 5)));
        this.statusJPanel = new JPanel();
        this.statusJPanel.setLayout(new FlowLayout(0, 5, 5));
        this.statusJPanel.setBackground(new Color(-1));
        this.mainPanel.add((Component)this.statusJPanel, cc.xyw(1, 14, 9));
        this.statusLbl = new JLabel();
        this.$$$loadLabelText$$$(this.statusLbl, this.$$$getMessageFromBundle$$$("locale", "WelcomeText"));
        this.statusJPanel.add(this.statusLbl);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.DVDRadioButton);
        buttonGroup.add(this.CDRadioButton);
    }

    private String $$$getMessageFromBundle$$$(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = this.getClass();
            if ($$$cachedGetBundleMethod$$$ == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                $$$cachedGetBundleMethod$$$ = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)$$$cachedGetBundleMethod$$$.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

