/*
 * Decompiled with CFR 0.152.
 */
package tihwin;

import java.util.Locale;
import java.util.prefs.Preferences;

public class Settings {
    public static final Settings INSTANCE = new Settings();
    private final Preferences preferences = Preferences.userRoot().node("tihwin");
    private final Locale locale;

    Settings() {
        String localeCode = this.preferences.get("locale", Locale.getDefault().toString());
        this.locale = new Locale(localeCode.substring(0, 2), localeCode.substring(3));
    }

    public String getRomLocation() {
        return this.preferences.get("rom_location", System.getProperty("user.home"));
    }

    public String getDestination() {
        return this.preferences.get("destination", System.getProperty("user.home"));
    }

    public boolean getDvdSelected() {
        return this.preferences.getBoolean("dvd_selected", true);
    }

    public void setDestination(String location) {
        this.preferences.put("destination", location);
    }

    public void setRomLocation(String location) {
        this.preferences.put("rom_location", location);
    }

    public void setDvdSelected(boolean value) {
        this.preferences.putBoolean("dvd_selected", value);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(String localeId) {
        this.preferences.put("locale", localeId);
    }

    public int getScaleFactor() {
        return this.preferences.getInt("scale", 0);
    }

    public void setScaleFactor(int value) {
        this.preferences.putInt("scale", value);
    }
}

