/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ui.model;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import tihwin.Settings;
import tihwin.ui.model.LocaleHolder;

public class SettingsLanguagesSetup {
    private final List<LocaleHolder> languages = new ArrayList<LocaleHolder>();
    private File thisApplicationFile;
    private LocaleHolder recentlyUsedLanguageHolder;

    public SettingsLanguagesSetup() {
        this.parseFiles();
        this.sortLanguages();
        this.defineRecentlyUsedLanguageHolder();
    }

    private void parseFiles() {
        if (this.isApplicationIsJar()) {
            this.parseFilesInsideJar();
        } else {
            this.parseFilesInFilesystem();
        }
    }

    private boolean isApplicationIsJar() {
        this.getThisApplicationFile();
        return this.thisApplicationFile != null && this.thisApplicationFile.isFile();
    }

    private void getThisApplicationFile() {
        try {
            String encodedJarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("+", "%2B");
            this.thisApplicationFile = new File(URLDecoder.decode(encodedJarLocation, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            this.thisApplicationFile = null;
        }
    }

    private void parseFilesInsideJar() {
        try {
            JarFile jar = new JarFile(this.thisApplicationFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith("locale_")) continue;
                this.languages.add(new LocaleHolder(name));
            }
            jar.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void parseFilesInFilesystem() {
        String[] filesList;
        URL resourceURL = this.getClass().getResource("/");
        for (String jarFileName : filesList = new File(resourceURL.getFile()).list()) {
            if (!jarFileName.startsWith("locale_")) continue;
            this.languages.add(new LocaleHolder(jarFileName));
        }
    }

    private void sortLanguages() {
        this.languages.sort(Comparator.comparing(LocaleHolder::toString));
    }

    private void defineRecentlyUsedLanguageHolder() {
        Locale localeFromPreferences = Settings.INSTANCE.getLocale();
        for (LocaleHolder holder : this.languages) {
            Locale holderLocale = holder.getLocale();
            if (!holderLocale.equals(localeFromPreferences)) continue;
            this.recentlyUsedLanguageHolder = holder;
            return;
        }
        for (LocaleHolder holder : this.languages) {
            if (!holder.getLocaleCode().equals("en_US")) continue;
            this.recentlyUsedLanguageHolder = holder;
            return;
        }
    }

    public List<LocaleHolder> getLanguages() {
        return this.languages;
    }

    public LocaleHolder getRecentLanguage() {
        return this.recentlyUsedLanguageHolder;
    }
}

