/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ul;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.ResourceBundle;
import tihwin.ui.UiUpdater;
import tihwin.ul.UlConfiguration;

public class UlMaker
implements Runnable {
    private final File fileToSplit;
    private final String ulLocation;
    private final UiUpdater updater;
    private final UlConfiguration ulConfiguration;
    private final ResourceBundle resourceBundle;
    private final String locationPattern;

    public UlMaker(File fileToSplit, String ulLocation, UlConfiguration ulConfiguration, UiUpdater updater) {
        this.ulLocation = ulLocation;
        this.ulConfiguration = ulConfiguration;
        this.fileToSplit = fileToSplit;
        this.updater = updater;
        this.resourceBundle = ResourceBundle.getBundle("locale");
        this.locationPattern = ulLocation + File.separator + String.format("ul.%s.%s.", ulConfiguration.getCrc32(), ulConfiguration.getPublisherTitle()) + "%02d";
    }

    @Override
    public void run() {
        try {
            this.splitToChunks();
            this.validateSplitFile();
            this.makeUlFile();
            this.updater.setStatus(this.resourceBundle.getString("SuccessText"));
        }
        catch (InterruptedException ie) {
            this.safeShutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!this.interrupted()) {
                this.updater.setStatus(this.resourceBundle.getString("FailedText") + " " + e.getMessage());
                return;
            }
            this.safeShutdown();
        }
        finally {
            this.updater.close();
        }
    }

    private void safeShutdown() {
        this.updater.setStatus(this.resourceBundle.getString("PleaseWaitText"));
        try {
            boolean isDeleted = true;
            for (int i = 0; i < this.ulConfiguration.getChunksCount(); ++i) {
                isDeleted &= Files.deleteIfExists(Paths.get(String.format(this.locationPattern, i), new String[0]));
            }
            if (isDeleted) {
                this.updater.setStatus(this.resourceBundle.getString("InterruptedAndFilesDeletedText"));
            } else {
                this.updater.setStatus(this.resourceBundle.getString("InterruptedAndFilesNotDeletedText"));
            }
        }
        catch (Exception e) {
            this.updater.setStatus(this.resourceBundle.getString("FailedText") + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void makeUlFile() throws Exception {
        byte[] config = this.ulConfiguration.generateUlConfig();
        try (RandomAccessFile raf = new RandomAccessFile(this.ulLocation + File.separator + "ul.cfg", "rw");){
            raf.seek(raf.length());
            raf.write(config);
        }
    }

    private void splitToChunks() throws Exception {
        block16: {
            try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(this.fileToSplit.toPath(), new OpenOption[0]));){
                this.updater.incrementProgressBar(this.fileToSplit.length());
                int chunkNumber = 0;
                while (true) {
                    String pathname = String.format(this.locationPattern, chunkNumber);
                    try (BufferedOutputStream fragmentBos = new BufferedOutputStream(Files.newOutputStream(Paths.get(pathname, new String[0]), new OpenOption[0]));){
                        for (long counter = 0L; counter < 256L; ++counter) {
                            byte[] chunk = new byte[0x400000];
                            int readBytesCount = bis.read(chunk);
                            if (readBytesCount < 0x400000) {
                                if (readBytesCount > 0) {
                                    fragmentBos.write(chunk, 0, readBytesCount);
                                }
                                fragmentBos.close();
                                this.updater.updateProgressBySize(readBytesCount);
                                break block16;
                            }
                            if (this.interrupted()) {
                                throw new InterruptedException();
                            }
                            fragmentBos.write(chunk);
                            this.updater.updateProgressBySize(readBytesCount);
                        }
                    }
                    ++chunkNumber;
                }
            }
        }
    }

    private void validateSplitFile() throws Exception {
        if (this.interrupted()) {
            throw new InterruptedException(this.resourceBundle.getString("InterruptedText"));
        }
        ArrayList<File> chunkFiles = new ArrayList<File>();
        for (int i = 0; i < this.ulConfiguration.getChunksCount(); ++i) {
            File chunkFile = new File(String.format(this.locationPattern, i));
            chunkFiles.add(chunkFile);
        }
        if (chunkFiles.size() == 0) {
            throw new Exception(this.resourceBundle.getString("UnableCheckResultsText"));
        }
        long totalChunksSize = 0L;
        for (File chunkFile : chunkFiles) {
            totalChunksSize += chunkFile.length();
        }
        if (this.fileToSplit.length() != totalChunksSize) {
            throw new Exception(this.resourceBundle.getString("SizesDifferent"));
        }
    }

    private boolean interrupted() {
        return Thread.interrupted();
    }
}

