/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ul;

import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import tihwin.ul.UlConfiguration;

public class UlServiceTools {
    public static boolean verifyChunksCount(String ulCfgLocation, UlConfiguration configuration) {
        int declaredChunksCount = configuration.getChunksCount();
        File[] files = UlServiceTools.collectChunks(ulCfgLocation, configuration);
        int realChunkCount = 0;
        for (File chunkFile : files) {
            if (!chunkFile.exists()) continue;
            ++realChunkCount;
        }
        return declaredChunksCount == realChunkCount;
    }

    private static File[] collectChunks(String ulCfgLocation, UlConfiguration configuration) {
        String pattern = UlServiceTools.makePattern(ulCfgLocation, configuration);
        int declaredChunksCount = configuration.getChunksCount();
        File[] files = new File[declaredChunksCount];
        for (int i = 0; i < declaredChunksCount; ++i) {
            File chunkFile;
            files[i] = chunkFile = new File(String.format(pattern, i));
        }
        return files;
    }

    private static String makePattern(String ulCfgLocation, UlConfiguration configuration) {
        return ulCfgLocation + File.separator + String.format("ul.%s.%s.", configuration.getCrc32(), configuration.getPublisherTitle()) + "%02d";
    }

    public static void renameChunks(String ulCfgLocation, UlConfiguration oldConfiguration, UlConfiguration newConfiguration) throws Exception {
        String pattern = UlServiceTools.makePattern(ulCfgLocation, newConfiguration);
        File[] files = UlServiceTools.collectChunks(ulCfgLocation, oldConfiguration);
        for (int i = 0; i < files.length; ++i) {
            String fileName = String.format(pattern, i);
            Files.move(files[i].toPath(), Paths.get(fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void removeChunks(String ulCfgLocation, UlConfiguration configuration) throws Exception {
        File[] files;
        for (File file : files = UlServiceTools.collectChunks(ulCfgLocation, configuration)) {
            Files.deleteIfExists(file.toPath());
        }
    }

    public static void writeUlCfgFile(String ulCfgLocation, List<UlConfiguration> fileContent) throws Exception {
        String ulCfg = ulCfgLocation + File.separator + "ul.cfg";
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(Paths.get(ulCfg, new String[0]), new OpenOption[0]));){
            for (UlConfiguration configuration : fileContent) {
                stream.write(configuration.generateUlConfig());
            }
        }
    }
}

