/*
 * Decompiled with CFR 0.152.
 */
package tihwin;

import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.UIManager;
import tihwin.AwesomeMediator;

public class ScaleUi {
    private static final String[] DEFAULTS = new String[]{"Label.font", "Button.font", "ComboBox.font", "TextField.font", "List.font", "Tree.font", "TableHeader.font"};

    public static void applyInitialScale(List<Component> components) {
        ScaleUi.applyOnAll(ScalePolicy.INIT, components);
    }

    public static void applyInitialScale(Component component) {
        ScaleUi.applyOn(component, AwesomeMediator.getScaleValue());
    }

    public static void increaseScale(List<Component> components) {
        ScaleUi.applyOnAll(ScalePolicy.INCREASE, components);
    }

    public static void decreaseScale(List<Component> components) {
        ScaleUi.applyOnAll(ScalePolicy.DECREASE, components);
    }

    private static void applyOnAll(ScalePolicy policy, List<Component> components) {
        switch (policy) {
            case INIT: {
                if (AwesomeMediator.getScaleValue() == 0) {
                    return;
                }
                for (Component component : components) {
                    ScaleUi.applyInitialScale(component);
                }
                ScaleUi.applyOnDefaults(ScalePolicy.INIT);
                break;
            }
            case INCREASE: {
                for (Component component : components) {
                    ScaleUi.applyOn(component, 1);
                }
                ScaleUi.applyOnDefaults(ScalePolicy.INCREASE);
                break;
            }
            case DECREASE: {
                if (AwesomeMediator.getScaleValue() <= 0) {
                    return;
                }
                for (Component component : components) {
                    ScaleUi.applyOn(component, -1);
                }
                ScaleUi.applyOnDefaults(ScalePolicy.DECREASE);
            }
        }
    }

    private static void applyOn(Component component, int factor) {
        Font defaultFont = component.getFont();
        component.setFont(new Font(defaultFont.getName(), defaultFont.getStyle(), defaultFont.getSize() + factor));
    }

    private static void applyOnDefaults(ScalePolicy policy) {
        switch (policy) {
            case INIT: {
                for (String defaultElement : DEFAULTS) {
                    ScaleUi.applyOnDefault(defaultElement, AwesomeMediator.getScaleValue());
                }
                break;
            }
            case INCREASE: {
                for (String defaultElement : DEFAULTS) {
                    ScaleUi.applyOnDefault(defaultElement, 1);
                }
                AwesomeMediator.increaseScaleValue();
                break;
            }
            case DECREASE: {
                for (String defaultElement : DEFAULTS) {
                    ScaleUi.applyOnDefault(defaultElement, -1);
                }
                AwesomeMediator.decreaseScaleValue();
            }
        }
    }

    private static void applyOnDefault(String componentName, int factor) {
        Font defaultFont = UIManager.getDefaults().getFont(componentName);
        UIManager.getDefaults().put(componentName, new Font(defaultFont.getName(), defaultFont.getStyle(), defaultFont.getSize() + factor));
    }

    public static enum ScalePolicy {
        INCREASE,
        DECREASE,
        INIT;

    }
}

