/*
 * Decompiled with CFR 0.152.
 */
package tihwin.cd;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.ResourceBundle;
import tihwin.cd.DirectoryEntry;

public class ISO9660 {
    private final RandomAccessFile randomAccessFile;
    private final ResourceBundle resourceBundle;
    private DirectoryEntry rootEntry;
    private String title;

    public ISO9660(File iso) throws Exception {
        this.randomAccessFile = new RandomAccessFile(iso, "r");
        this.resourceBundle = ResourceBundle.getBundle("locale");
        this.skipFirst16Sectors();
        this.getRootDirectoryDescriptor();
        this.getSystemCnfContent();
    }

    private void skipFirst16Sectors() throws Exception {
        this.randomAccessFile.seek(32768L);
    }

    private void getRootDirectoryDescriptor() throws Exception {
        byte[] firstPayloadDescriptor = new byte[2048];
        if (2048 != this.randomAccessFile.read(firstPayloadDescriptor)) {
            throw new Exception(this.resourceBundle.getString("ISO_CantReadISOInitialDescriptorText"));
        }
        byte type = firstPayloadDescriptor[0];
        String identifier = new String(firstPayloadDescriptor, 1, 5, StandardCharsets.US_ASCII);
        byte version = firstPayloadDescriptor[6];
        if (type != 1) {
            throw new Exception(this.resourceBundle.getString("ISO_NotSupportedCdDvd") + " Type " + type);
        }
        if (!identifier.contentEquals("CD001")) {
            throw new Exception(this.resourceBundle.getString("ISO_NotSupportedCdDvd") + " Identifier " + identifier);
        }
        if (version != 1) {
            throw new Exception(this.resourceBundle.getString("ISO_NotSupportedCdDvd") + " Version " + version);
        }
        this.rootEntry = new DirectoryEntry(Arrays.copyOfRange(firstPayloadDescriptor, 156, 190));
    }

    private void getSystemCnfContent() throws Exception {
        int entryLength;
        this.randomAccessFile.seek((long)this.rootEntry.getExtentLocation() * 2048L);
        byte[] bytes = new byte[this.rootEntry.getDataSize()];
        if (this.rootEntry.getDataSize() != this.randomAccessFile.read(bytes)) {
            throw new Exception(this.resourceBundle.getString("ISO_CantReadRootDescriptor"));
        }
        for (int entryOffset = 0; entryOffset < this.rootEntry.getDataSize() && (entryLength = Byte.toUnsignedInt(bytes[entryOffset])) != 0; entryOffset += entryLength) {
            byte[] entryBytes = Arrays.copyOfRange(bytes, entryOffset, entryOffset + entryLength);
            DirectoryEntry entryIn = new DirectoryEntry(entryBytes);
            if (!entryIn.getIdentifier().toUpperCase().contains("SYSTEM.CNF")) continue;
            this.randomAccessFile.seek((long)entryIn.getExtentLocation() * 2048L);
            byte[] configurationData = new byte[entryIn.getDataSize()];
            this.randomAccessFile.read(configurationData);
            String systemCnf = new String(configurationData, StandardCharsets.UTF_8);
            this.getTitleFromSystemCnf(systemCnf);
            return;
        }
        throw new Exception(this.resourceBundle.getString("ISO_NoSystemCnf"));
    }

    private void getTitleFromSystemCnf(String systemCnf) throws Exception {
        String systemCnfOneLine = systemCnf.replace("\n", "").replace("\r", "");
        this.title = systemCnfOneLine.replaceAll("(.*cdrom0:\\\\)|(;.*)", "");
        if (this.title.length() == 0) {
            throw new Exception(this.resourceBundle.getString("ISO_PublisherTitleNotFound") + " " + systemCnf);
        }
    }

    public String getTitle() {
        return this.title;
    }
}

