/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ui;

import javax.swing.JLabel;
import javax.swing.JProgressBar;
import tihwin.AwesomeMediator;

public class UiUpdater {
    private final JProgressBar progressBar;
    private final JLabel statusLine;
    private volatile float totalFilesSizeInBytes;
    private volatile long bytesDone;

    public UiUpdater(JProgressBar progressBar, JLabel statusLine) {
        this.progressBar = progressBar;
        this.statusLine = statusLine;
        progressBar.setMaximum(100);
        progressBar.setStringPainted(true);
    }

    public synchronized void updateProgressBySize(int value) {
        this.bytesDone += (long)value;
        this.progressBar.setValue((int)((float)this.bytesDone / this.totalFilesSizeInBytes * 100.0f));
    }

    public void setStatus(String status) {
        this.statusLine.setText(status);
    }

    public synchronized void incrementProgressBar(long fileSize) {
        this.totalFilesSizeInBytes += (float)fileSize;
    }

    public void close() {
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(false);
        AwesomeMediator.notifyAllConvertsEnded();
    }
}

