/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import javax.swing.JPanel;
import tihwin.AwesomeMediator;
import tihwin.UpdateUlTableUi;

public class FilesDropListener
extends DropTargetAdapter {
    public FilesDropListener(JPanel panel) {
        new DropTarget(panel, 1, this, true, null);
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (!event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            event.rejectDrop();
            return;
        }
        event.acceptDrop(1);
        Transferable transferable = event.getTransferable();
        try {
            List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            for (File file : files) {
                if (file.isDirectory()) {
                    AwesomeMediator.setDestination(file);
                } else if (file.getName().toLowerCase().endsWith(".iso")) {
                    AwesomeMediator.setDiskImage(file);
                } else {
                    if (!file.isFile() || !file.getName().equalsIgnoreCase("ul.cfg")) continue;
                    new UpdateUlTableUi(file.getParentFile().getAbsolutePath());
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            event.rejectDrop();
        }
        event.dropComplete(true);
    }
}

