/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ui.ulupdater;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import tihwin.ui.ulupdater.UlTableModelRecord;

public class UlTableModel
extends DefaultTableModel {
    private final String REMOVE_ME_BUTTON_TEXT;
    private final String OK_STATUS;
    private final String INCONSISTENT_STATUS;
    private final List<UlTableModelRecord> rows;
    private final List<UlTableModelRecord> removedRows;

    public UlTableModel() {
        ResourceBundle bundle = ResourceBundle.getBundle("locale");
        Object[] columns = new String[]{bundle.getString("ulManagerWindow_ColumnNameNumber"), bundle.getString("ulManagerWindow_ColumnNameTitle"), bundle.getString("ulManagerWindow_ColumnNamePublisherTitle"), bundle.getString("ulManagerWindow_ColumnNameChunksCount"), bundle.getString("ulManagerWindow_ColumnCdDvdFlag"), "", ""};
        super.setColumnIdentifiers(columns);
        this.REMOVE_ME_BUTTON_TEXT = bundle.getString("ulManagerWindow_Row_RemoveRowBtn");
        this.OK_STATUS = bundle.getString("Ok");
        this.INCONSISTENT_STATUS = bundle.getString("ulManagerWindow_InconsistentFileText");
        this.rows = new ArrayList<UlTableModelRecord>();
        this.removedRows = new ArrayList<UlTableModelRecord>();
    }

    public void addRow(UlTableModelRecord record) {
        this.rows.add(record);
        super.addRow(new Object[]{this.rows.size(), record.getConfiguration().getTitle(), record.getConfiguration().getPublisherTitle(), record.getConfiguration().getChunksCount(), record.getConfiguration().isDvd() ? "DVD" : "CD", new JButton(this.REMOVE_ME_BUTTON_TEXT), record.isConsistent() ? this.OK_STATUS : this.INCONSISTENT_STATUS});
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 5) {
            return JButton.class;
        }
        return JLabel.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeRow(int row) {
        this.removedRows.add(this.rows.get(row));
        this.rows.remove(row);
        super.removeRow(row);
        for (int i = row; i < this.rows.size(); ++i) {
            this.setValueAt(i + 1, i, 0);
        }
    }

    public void clear() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            super.removeRow(i);
        }
        this.rows.clear();
        this.removedRows.clear();
    }

    public List<UlTableModelRecord> getInitialRows() {
        return this.rows;
    }

    public List<UlTableModelRecord> getRemovedRows() {
        return this.removedRows;
    }

    public String getTitle(int row) {
        return (String)this.getValueAt(row, 1);
    }

    public String getPublisherTitle(int row) {
        return (String)this.getValueAt(row, 2);
    }

    public byte getChunksCount(int row) {
        return (Byte)this.getValueAt(row, 3);
    }

    public String getCdDvd(int row) {
        return (String)this.getValueAt(row, 4);
    }
}

