/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ul;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;

public class UlConfiguration {
    private static final byte DVD_FLAG = 20;
    private static final byte CD_FLAG = 18;
    private final String title;
    private final String publisherTitle;
    private final String crc32;
    private final byte chunksCount;
    private final byte cdDvdFlag;
    private final boolean romIsDvdImage;

    public UlConfiguration(File ulCfg, int recordNumber) throws Exception {
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(ulCfg.toPath(), new OpenOption[0]));){
            int offset = recordNumber * 64;
            int read = 0;
            while (offset != read) {
                read = (int)((long)read + stream.skip(offset));
            }
            byte[] buffer = new byte[64];
            if (64 != stream.read(buffer)) {
                throw new Exception(recordNumber + " 0x40");
            }
            this.title = new String(buffer, 0, 32, StandardCharsets.US_ASCII).trim();
            this.publisherTitle = new String(buffer, 35, 11, StandardCharsets.US_ASCII).trim();
            this.crc32 = String.format("%08x", this.OplCRC32(this.title)).toUpperCase();
            this.chunksCount = buffer[47];
            this.cdDvdFlag = buffer[48];
            this.romIsDvdImage = this.cdDvdFlag == 20;
        }
    }

    public UlConfiguration(String title, String publisherTitle, byte chunksCount, boolean isDVD) throws Exception {
        this.title = title;
        this.publisherTitle = publisherTitle;
        this.crc32 = String.format("%08x", this.OplCRC32(title)).toUpperCase();
        this.chunksCount = chunksCount;
        this.cdDvdFlag = isDVD ? (byte)20 : (byte)18;
        this.romIsDvdImage = isDVD;
    }

    private int OplCRC32(String string) throws Exception {
        if ((string = string.trim()).length() > 31) {
            throw new Exception("Maximum title length exceed. Must be less than 32 symbols!");
        }
        byte[] decodedString = Arrays.copyOf(string.getBytes(StandardCharsets.US_ASCII), 32);
        int crc = 0;
        int[] crcTable = new int[256];
        for (int table = 0; table < 256; ++table) {
            crc = table << 24;
            for (int i = 8; i > 0; --i) {
                if (crc < 0) {
                    crc <<= 1;
                    continue;
                }
                crc = crc << 1 ^ 0x4C11DB7;
            }
            crcTable[255 - table] = crc;
        }
        for (int i = 0; i <= string.length(); ++i) {
            byte bytes = decodedString[i];
            crc = crcTable[bytes ^ crc >> 24 & 0xFF] ^ crc << 8 & 0xFFFFFF00;
        }
        return crc;
    }

    public String getCrc32() {
        return this.crc32;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isDvd() {
        return this.romIsDvdImage;
    }

    public String getPublisherTitle() {
        return this.publisherTitle;
    }

    public byte getChunksCount() {
        return this.chunksCount;
    }

    public byte[] generateUlConfig() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        byteBuffer.put(this.title.getBytes(StandardCharsets.US_ASCII));
        ((Buffer)byteBuffer).position(32);
        byteBuffer.put(("ul." + this.publisherTitle).getBytes());
        ((Buffer)byteBuffer).position(47);
        byteBuffer.put(this.chunksCount);
        byteBuffer.put(this.cdDvdFlag);
        ((Buffer)byteBuffer).position(53);
        byteBuffer.put((byte)8);
        ((Buffer)byteBuffer).flip();
        return byteBuffer.array();
    }
}

