/*
 * Decompiled with CFR 0.152.
 */
package tihwin.cd;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class DirectoryEntry {
    private final int extentLocation;
    private final int dataSize;
    private final String identifier;

    public DirectoryEntry(byte[] entryBytes) {
        this.extentLocation = this.getLEint(entryBytes, 2);
        this.dataSize = this.getLEint(entryBytes, 10);
        byte identifierLength = entryBytes[32];
        this.identifier = new String(entryBytes, 33, (int)identifierLength, StandardCharsets.US_ASCII);
    }

    private int getLEint(byte[] bytes, int fromOffset) {
        return ByteBuffer.wrap(bytes, fromOffset, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public int getExtentLocation() {
        return this.extentLocation;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

