/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class TitleFieldFilter
extends DocumentFilter {
    private static final int MAX_USER_DEFINED_GAME_TITLE_LENGTH = 32;

    protected boolean isNotAscii(String str) {
        if (str == null) {
            return false;
        }
        return !str.matches("\\A\\p{ASCII}*\\z");
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet attr) throws BadLocationException {
        if (this.isNotAscii(str)) {
            return;
        }
        int documentLength = fb.getDocument().getLength();
        if (documentLength + str.length() < 32) {
            super.insertString(fb, offs, str, attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet attr) throws BadLocationException {
        if (this.isNotAscii(str)) {
            return;
        }
        int documentLength = fb.getDocument().getLength();
        if (documentLength + str.length() - length < 32) {
            super.replace(fb, offs, length, str, attr);
        }
    }
}

