/*
 * Decompiled with CFR 0.152.
 */
package tihwin;

import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.UIManager;
import tihwin.AwesomeMediator;

public class ScaleUi {
    private static final String[] DEFAULTS = new String[]{"Label.font", "Button.font", "ComboBox.font", "TextField.font", "List.font", "Tree.font", "TableHeader.font"};

    public static void applyInitialScale(List<Component> components) {
        if (AwesomeMediator.getScaleValue() == 0) {
            return;
        }
        for (Component component : components) {
            ScaleUi.applyInitialScale(component);
        }
        ScaleUi.applyOnDefaults(ScalePolicy.INIT);
    }

    public static void applyInitialScale(Component component) {
        ScaleUi.applyOn(component, AwesomeMediator.getScaleValue());
    }

    public static void increaseScale(List<Component> components) {
        for (Component component : components) {
            ScaleUi.increaseScale(component);
        }
        ScaleUi.applyOnDefaults(ScalePolicy.INCREASE);
    }

    private static void increaseScale(Component component) {
        ScaleUi.applyOn(component, 1);
    }

    public static void decreaseScale(List<Component> components) {
        if (AwesomeMediator.getScaleValue() <= 0) {
            return;
        }
        for (Component component : components) {
            ScaleUi.decreaseScale(component);
        }
        ScaleUi.applyOnDefaults(ScalePolicy.DECREASE);
    }

    private static void decreaseScale(Component component) {
        ScaleUi.applyOn(component, -1);
    }

    private static void applyOn(Component component, int factor) {
        Font defaultFont = component.getFont();
        component.setFont(new Font(defaultFont.getName(), defaultFont.getStyle(), defaultFont.getSize() + factor));
    }

    private static void applyOnDefaults(ScalePolicy policy) {
        switch (policy) {
            case INIT: {
                for (String defaultElement : DEFAULTS) {
                    ScaleUi.initDefault(defaultElement);
                }
                break;
            }
            case INCREASE: {
                for (String defaultElement : DEFAULTS) {
                    ScaleUi.increaseDefault(defaultElement);
                }
                AwesomeMediator.increaseScaleValue();
                break;
            }
            case DECREASE: {
                for (String defaultElement : DEFAULTS) {
                    ScaleUi.decreaseDefault(defaultElement);
                }
                AwesomeMediator.decreaseScaleValue();
            }
        }
    }

    private static void initDefault(String name) {
        ScaleUi.applyOnDefault(name, AwesomeMediator.getScaleValue());
    }

    private static void increaseDefault(String name) {
        ScaleUi.applyOnDefault(name, 1);
    }

    private static void decreaseDefault(String name) {
        ScaleUi.applyOnDefault(name, -1);
    }

    private static void applyOnDefault(String name, int factor) {
        Font defaultFont = UIManager.getDefaults().getFont(name);
        UIManager.getDefaults().put(name, new Font(defaultFont.getName(), defaultFont.getStyle(), defaultFont.getSize() + factor));
    }

    public static enum ScalePolicy {
        INCREASE,
        DECREASE,
        INIT;

    }
}

