/*
 * Decompiled with CFR 0.152.
 */
package tihwin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import tihwin.AwesomeMediator;
import tihwin.FilesHelper;
import tihwin.MainAppUi;
import tihwin.ui.ulupdater.UlCfgFileFilter;
import tihwin.ui.ulupdater.UlTableColumnModel;
import tihwin.ui.ulupdater.UlTableContentJButtonRenderer;
import tihwin.ui.ulupdater.UlTableContentJLabelRenderer;
import tihwin.ui.ulupdater.UlTableHeaderRenderer;
import tihwin.ui.ulupdater.UlTableModel;
import tihwin.ui.ulupdater.UlTableModelRecord;
import tihwin.ul.UlConfiguration;
import tihwin.ul.UlServiceTools;

public class UpdateUlTableUi
extends JFrame {
    private JTable table;
    private UlTableModel model;
    private JButton saveChangesBtn;
    private JButton selectUlBtn;
    private final JLabel ulLocationLbl;
    private JLabel statusLbl;
    private String recentRomLocation;
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle("locale");

    public UpdateUlTableUi(String ulDestinationLocation) {
        this.ulLocationLbl = new JLabel(ulDestinationLocation);
        this.recentRomLocation = ulDestinationLocation;
        this.setupTable();
        this.setupSaveButton();
        this.createSelectUlLocationButton();
        FormLayout primaryPanelLayout = new FormLayout("80dlu, 2dlu, fill:pref:grow", "fill:pref:grow, 25dlu:noGrow, 25dlu:noGrow, fill:pref:noGrow");
        JPanel primaryPanel = new JPanel();
        primaryPanel.setLayout(primaryPanelLayout);
        primaryPanel.add((Component)this.getScrollPane(), new CellConstraints(1, 1, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        primaryPanel.add((Component)this.selectUlBtn, new CellConstraints(1, 2, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(3, 3, 3, 3)));
        primaryPanel.add((Component)this.ulLocationLbl, new CellConstraints(3, 2, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        primaryPanel.add((Component)this.saveChangesBtn, new CellConstraints(1, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(3, 3, 3, 3)));
        primaryPanel.add((Component)this.getStatusPanel(), new CellConstraints(1, 4, 3, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.setLocationRelativeTo(null);
        this.setContentPane(primaryPanel);
        this.setDefaultCloseOperation(2);
        Image img = new ImageIcon(Objects.requireNonNull(MainAppUi.class.getClassLoader().getResource("tray_icon.gif"))).getImage();
        this.setIconImage(img);
        int scaledWidth = (int)(800.0 * ((double)AwesomeMediator.getScaleValue() / 20.0 + 1.0));
        this.setMinimumSize(new Dimension(scaledWidth, 500));
        this.setVisible(true);
        this.setTitle(this.resourceBundle.getString("ulManager"));
        File ulCfgFile = new File(ulDestinationLocation + File.separator + "ul.cfg");
        if (ulCfgFile.exists()) {
            this.showInTableUlCfgFile(ulCfgFile);
        }
    }

    private void setupSaveButton() {
        this.saveChangesBtn = new JButton(this.resourceBundle.getString("ulManagerWindow_SaveBtn"));
        this.saveChangesBtn.setBackground(Color.getHSBColor(0.5591398f, 0.12156863f, 1.0f));
        this.saveChangesBtn.addActionListener(actionEvent -> this.saveChangesAction());
        this.saveChangesBtn.setEnabled(false);
    }

    private void setupTable() {
        this.model = new UlTableModel();
        this.table = new JTable(this.model);
        JTableHeader header = this.table.getTableHeader();
        header.setDefaultRenderer(new UlTableHeaderRenderer());
        header.setPreferredSize(new Dimension(header.getHeight(), 25));
        this.table.setDefaultRenderer(JButton.class, new UlTableContentJButtonRenderer());
        this.table.setDefaultRenderer(JLabel.class, new UlTableContentJLabelRenderer());
        this.table.setRowHeight(30);
        UlTableColumnModel columnModel = new UlTableColumnModel((DefaultTableColumnModel)this.table.getColumnModel());
        this.table.setColumnModel(columnModel);
        this.table.setRowSelectionAllowed(false);
    }

    private JScrollPane getScrollPane() {
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(0, 50));
        return scrollPane;
    }

    private void createSelectUlLocationButton() {
        this.selectUlBtn = new JButton(this.resourceBundle.getString("ulManagerWindow_SelectUlCfgBtn"));
        this.selectUlBtn.setBackground(Color.getHSBColor(0.5591398f, 0.12156863f, 1.0f));
        this.selectUlBtn.addActionListener(actionEvent -> this.selectUlCfgAction());
    }

    private JPanel getStatusPanel() {
        this.statusLbl = new JLabel();
        JPanel statusPanel = new JPanel(new FlowLayout(0));
        statusPanel.setBackground(Color.white);
        statusPanel.setBorder(new MatteBorder(1, 0, 0, 0, Color.darkGray));
        statusPanel.add(this.statusLbl);
        return statusPanel;
    }

    private void showInTableUlCfgFile(File ulCfgFile) {
        try {
            if (ulCfgFile.length() < 64L) {
                this.statusLbl.setText(this.resourceBundle.getString("ulManagerWindow_EmptyOrIncorrectText") + " " + ulCfgFile.getAbsolutePath());
                return;
            }
            this.model.clear();
            String ulCfgFileLocation = ulCfgFile.getParentFile().getAbsolutePath();
            int i = 0;
            while ((long)i < ulCfgFile.length() / 64L) {
                UlConfiguration ulConfiguration = new UlConfiguration(ulCfgFile, i);
                boolean isConsistent = UlServiceTools.verifyChunksCount(ulCfgFileLocation, ulConfiguration);
                this.model.addRow(new UlTableModelRecord(ulConfiguration, isConsistent));
                ++i;
            }
            this.saveChangesBtn.setEnabled(true);
            this.ulLocationLbl.setText(ulCfgFile.getParentFile().getAbsolutePath());
            this.statusLbl.setText(ulCfgFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.statusLbl.setText(this.resourceBundle.getString("ulManagerWindow_EmptyOrIncorrectText") + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveChangesAction() {
        try {
            int i;
            String ulLocation = this.ulLocationLbl.getText();
            List<UlTableModelRecord> modelRecords = this.model.getInitialRows();
            ArrayList<UlConfiguration> finalConfigurationSet = new ArrayList<UlConfiguration>();
            for (i = 0; i < modelRecords.size(); ++i) {
                UlConfiguration configuration = new UlConfiguration(this.model.getTitle(i), this.model.getPublisherTitle(i), this.model.getChunksCount(i), this.model.getCdDvd(i).equals("DVD"));
                finalConfigurationSet.add(configuration);
            }
            for (i = 0; i < modelRecords.size(); ++i) {
                UlTableModelRecord initialRecord = modelRecords.get(i);
                String initialRecordTitle = initialRecord.getConfiguration().getTitle();
                if (!initialRecord.isConsistent() || this.model.getTitle(i).equals(initialRecordTitle)) continue;
                UlServiceTools.renameChunks(ulLocation, initialRecord.getConfiguration(), (UlConfiguration)finalConfigurationSet.get(i));
            }
            List<UlTableModelRecord> removedRows = this.model.getRemovedRows();
            for (UlTableModelRecord removedRow : removedRows) {
                UlServiceTools.removeChunks(ulLocation, removedRow.getConfiguration());
            }
            UlServiceTools.writeUlCfgFile(ulLocation, finalConfigurationSet);
            File ulCfgFile = new File(ulLocation + File.separator + "ul.cfg");
            if (ulCfgFile.length() == 0L) {
                Files.deleteIfExists(ulCfgFile.toPath());
                this.saveChangesBtn.setEnabled(false);
            } else {
                this.showInTableUlCfgFile(ulCfgFile);
            }
            this.statusLbl.setText(this.resourceBundle.getString("SuccessText"));
        }
        catch (Exception e) {
            this.statusLbl.setText(this.resourceBundle.getString("ulManagerWindow_SaveChangesFailureText") + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void selectUlCfgAction() {
        try {
            JFileChooser fileChooser = new JFileChooser(FilesHelper.getRealFolder(this.recentRomLocation));
            fileChooser.setDialogTitle(this.resourceBundle.getString("ulManagerWindow_SelectUlCfgBtn"));
            fileChooser.setFileFilter(new UlCfgFileFilter());
            if (fileChooser.showOpenDialog(null) == 0) {
                File file = fileChooser.getSelectedFile();
                this.recentRomLocation = file.getParent();
                this.showInTableUlCfgFile(file);
            }
        }
        catch (Exception e) {
            this.statusLbl.setText(e.getMessage());
            e.printStackTrace();
        }
    }
}

