/*
 * Decompiled with CFR 0.152.
 */
package tihwin.ui;

import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import tihwin.ui.model.LocaleHolder;
import tihwin.ui.model.SettingsLanguagesSetup;

public class LanguageComboBox
extends JComboBox<LocaleHolder> {
    private static final Color COLOR_SKY_BLUE = new Color(114, 211, 253);
    private static final Color COLOR_DARK = new Color(71, 81, 93);
    private static final Border BORDER = new EmptyBorder(5, 10, 5, 10);

    public LanguageComboBox() {
        UIManager.put("ComboBox.selectionForeground", COLOR_DARK);
        UIManager.put("ComboBox.selectionBackground", COLOR_SKY_BLUE);
        UIManager.put("ComboBox.squareButton", Boolean.FALSE);
        this.setUI(new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                JButton button = new JButton();
                button.setBackground(COLOR_SKY_BLUE);
                button.setBorder(BorderFactory.createEmptyBorder());
                button.setVisible(false);
                return button;
            }
        });
        ListCellRenderer current = this.getRenderer();
        this.setRenderer((list, localeHolder, index, isSelected, hasFocus) -> {
            JLabel component = (JLabel)current.getListCellRendererComponent(list, localeHolder, index, isSelected, hasFocus);
            component.setHorizontalAlignment(4);
            component.setBorder(BORDER);
            if (isSelected) {
                component.setForeground(COLOR_DARK);
                component.setBackground(Color.ORANGE);
            } else {
                component.setForeground(Color.white);
                component.setBackground(COLOR_DARK);
            }
            return component;
        });
        this.setForeground(Color.white);
        this.setBackground(COLOR_SKY_BLUE);
        SettingsLanguagesSetup setup = new SettingsLanguagesSetup();
        List<LocaleHolder> languages = setup.getLanguages();
        for (LocaleHolder lang : languages) {
            this.addItem(lang);
        }
        this.setSelectedItem(setup.getRecentLanguage());
    }
}

