/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.splitmerge;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.splitmerge.MergeSubTask;
import nsusbloader.Utilities.splitmerge.MultithreadingPrintAdapter;
import nsusbloader.Utilities.splitmerge.SplitSubTask;

public class SplitMergeTaskExecutor
implements Runnable {
    private final boolean isSplit;
    private final List<File> files;
    private final String saveToPath;
    private final ILogPrinter logPrinter;
    private final ExecutorService executorService;
    private final MultithreadingPrintAdapter printAdapter;

    public SplitMergeTaskExecutor(boolean isSplit, List<File> files, String saveToPath) {
        this.isSplit = isSplit;
        this.files = files;
        this.saveToPath = saveToPath;
        this.logPrinter = Log.getPrinter(EModule.SPLIT_MERGE_TOOL);
        this.executorService = Executors.newFixedThreadPool(files.size(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        });
        this.printAdapter = new MultithreadingPrintAdapter(this.logPrinter);
    }

    @Override
    public void run() {
        try {
            List<Future<Boolean>> futuresResults = this.executorService.invokeAll(this.getSubTasksCollection());
            boolean onelinerResult = true;
            for (Future<Boolean> future : futuresResults) {
                onelinerResult &= future.get().booleanValue();
            }
            this.executorService.shutdown();
            this.logPrinter.updateOneLinerStatus(onelinerResult);
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            boolean interruptedSuccessfully = false;
            try {
                interruptedSuccessfully = this.executorService.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException awaitInterrupt) {
                this.print("Force interrupting task...", EMsgType.WARNING);
            }
            this.logPrinter.updateOneLinerStatus(false);
            this.print((this.isSplit ? "Split tasks interrupted " : "Merge tasks interrupted ") + (interruptedSuccessfully ? "successfully" : "with some issues"), EMsgType.WARNING);
        }
        catch (Exception e) {
            this.logPrinter.updateOneLinerStatus(false);
            this.print((String)(this.isSplit ? "Split task failed: " : "Merge task failed: " + e.getMessage()), EMsgType.FAIL);
            e.printStackTrace();
        }
        this.print(this.isSplit ? ".:: Split complete ::." : ".:: Merge complete ::.", EMsgType.INFO);
        this.logPrinter.close();
    }

    private List<Callable<Boolean>> getSubTasksCollection() throws InterruptedException {
        ArrayList<Callable<Boolean>> subTasks = new ArrayList<Callable<Boolean>>();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isSplit) {
            stringBuilder.append("Split files:\n");
            for (int i = 0; i < this.files.size(); ++i) {
                File file = this.files.get(i);
                stringBuilder.append("[");
                stringBuilder.append(i);
                stringBuilder.append("] ");
                stringBuilder.append(file.getName());
                stringBuilder.append("\n");
                SplitSubTask task = new SplitSubTask(i, file, this.saveToPath, this.printAdapter);
                subTasks.add(task);
            }
        } else {
            stringBuilder.append("Merge files:\n");
            for (int i = 0; i < this.files.size(); ++i) {
                File file = this.files.get(i);
                stringBuilder.append("[");
                stringBuilder.append(i);
                stringBuilder.append("] ");
                stringBuilder.append(file.getName());
                stringBuilder.append("\n");
                MergeSubTask task = new MergeSubTask(i, file, this.saveToPath, this.printAdapter);
                subTasks.add(task);
            }
        }
        this.logPrinter.print(stringBuilder.toString(), EMsgType.INFO);
        return subTasks;
    }

    private void print(String message, EMsgType type) {
        try {
            this.logPrinter.print(message, type);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

