/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.aesctr;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import libKonogonka.RainbowDump;
import libKonogonka.aesctr.AesCtrDecrypt;
import libKonogonka.aesctr.AesCtrDecryptClassic;
import libKonogonka.aesctr.AesCtrDecryptForMediaBlocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AesCtrBufferedInputStream
extends BufferedInputStream {
    private static final Logger log = LogManager.getLogger(AesCtrBufferedInputStream.class);
    private final AesCtrDecrypt decryptor;
    private final long encryptedStartOffset;
    private final long encryptedEndOffset;
    private final long fileSize;
    private byte[] decryptedBytes;
    private long pseudoPos;
    private int pointerInsideDecryptedSection;

    public AesCtrBufferedInputStream(AesCtrDecryptForMediaBlocks decryptor, long ncaOffsetPosition, long mediaStartOffset, long mediaEndOffset, InputStream inputStream, long fileSize) {
        super(inputStream, 512);
        this.decryptor = decryptor;
        this.encryptedStartOffset = ncaOffsetPosition + mediaStartOffset * 512L;
        this.encryptedEndOffset = ncaOffsetPosition + mediaEndOffset * 512L;
        this.fileSize = fileSize;
        log.trace("\n  Offset Position             " + ncaOffsetPosition + "\n  MediaOffsetPositionStart    " + RainbowDump.formatDecHexString(this.encryptedStartOffset) + "\n  MediaOffsetPositionEnd      " + RainbowDump.formatDecHexString(this.encryptedEndOffset));
    }

    public AesCtrBufferedInputStream(AesCtrDecryptClassic decryptor, long encryptedStartOffset, long encryptedEndOffset, InputStream inputStream, long fileSize) {
        super(inputStream, 512);
        this.decryptor = decryptor;
        this.encryptedStartOffset = encryptedStartOffset;
        this.encryptedEndOffset = encryptedEndOffset;
        this.fileSize = fileSize;
        log.trace("  EncryptedStartOffset   : " + RainbowDump.formatDecHexString(encryptedStartOffset) + "\n  EncryptedEndOffset     : " + RainbowDump.formatDecHexString(encryptedEndOffset));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off != 0 || len != b.length) {
            throw new IOException("Not supported");
        }
        if (this.isPointerInsideEncryptedSection()) {
            int bytesFromFirstBlock = 512 - this.pointerInsideDecryptedSection;
            if (bytesFromFirstBlock > len) {
                log.trace("1.2. Pointer Inside + End Position Inside (Decrypted) Encrypted Section (" + this.pseudoPos + "-" + (this.pseudoPos + (long)b.length) + ")");
                System.arraycopy(this.decryptedBytes, this.pointerInsideDecryptedSection, b, 0, len);
                this.pseudoPos += (long)len;
                this.pointerInsideDecryptedSection += len;
                return b.length;
            }
            if (this.isEndPositionInsideEncryptedSection(b.length)) {
                log.trace("1.1. Pointer Inside + End Position Inside Encrypted Section (" + this.pseudoPos + "-" + (this.pseudoPos + (long)b.length) + ")");
                int middleBlocksCount = (len - bytesFromFirstBlock) / 512;
                int bytesFromLastBlock = (len - bytesFromFirstBlock) % 512;
                System.arraycopy(this.decryptedBytes, this.pointerInsideDecryptedSection, b, 0, bytesFromFirstBlock);
                for (int i = 0; i < middleBlocksCount; ++i) {
                    this.fillDecryptedCache();
                    System.arraycopy(this.decryptedBytes, 0, b, bytesFromFirstBlock + i * 512, 512);
                }
                if (this.fileSize > this.pseudoPos + (long)len) {
                    this.fillDecryptedCache();
                    System.arraycopy(this.decryptedBytes, 0, b, bytesFromFirstBlock + middleBlocksCount * 512, bytesFromLastBlock);
                }
                this.pseudoPos += (long)len;
                this.pointerInsideDecryptedSection = bytesFromLastBlock;
                return b.length;
            }
            log.trace("1. Pointer Inside + End Position Outside Encrypted Section (" + this.pseudoPos + "-" + (this.pseudoPos + (long)b.length) + ")");
            int middleBlocksCount = (int)((this.encryptedEndOffset - (this.pseudoPos + (long)bytesFromFirstBlock)) / 512L);
            int bytesFromEnd = len - bytesFromFirstBlock - middleBlocksCount * 512;
            System.arraycopy(this.decryptedBytes, this.pointerInsideDecryptedSection, b, 0, bytesFromFirstBlock);
            for (int i = 0; i < middleBlocksCount; ++i) {
                this.fillDecryptedCache();
                System.arraycopy(this.decryptedBytes, 0, b, bytesFromFirstBlock + i * 512, 512);
            }
            System.arraycopy(this.readChunk(bytesFromEnd), 0, b, bytesFromFirstBlock + middleBlocksCount * 512, bytesFromEnd);
            this.pseudoPos += (long)len;
            this.pointerInsideDecryptedSection = 0;
            return b.length;
        }
        if (this.isEndPositionInsideEncryptedSection(len)) {
            log.trace("2. End Position Inside Encrypted Section (" + this.pseudoPos + "-" + (this.pseudoPos + (long)b.length) + ")");
            int bytesTillEncrypted = (int)(this.encryptedStartOffset - this.pseudoPos);
            int fullEncryptedBlocks = (len - bytesTillEncrypted) / 512;
            int incompleteEncryptedBytes = (len - bytesTillEncrypted) % 512;
            System.arraycopy(this.readChunk(bytesTillEncrypted), 0, b, 0, bytesTillEncrypted);
            for (int i = 0; i < fullEncryptedBlocks; ++i) {
                this.fillDecryptedCache();
                System.arraycopy(this.decryptedBytes, 0, b, fullEncryptedBlocks + i * 512, 512);
            }
            this.fillDecryptedCache();
            System.arraycopy(this.decryptedBytes, 0, b, bytesTillEncrypted + fullEncryptedBlocks * 512, incompleteEncryptedBytes);
            this.pseudoPos += (long)len;
            this.pointerInsideDecryptedSection = incompleteEncryptedBytes;
            return b.length;
        }
        log.trace("3. Not encrypted (" + this.pseudoPos + "-" + (this.pseudoPos + (long)b.length) + ")");
        this.pseudoPos += (long)len;
        this.pointerInsideDecryptedSection = 0;
        return super.read(b);
    }

    private void fillDecryptedCache() throws IOException {
        try {
            this.decryptedBytes = this.decryptor.decryptNext(this.readChunk(512));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void resetAndSkip(long blockSum) throws IOException {
        try {
            this.decryptor.resetAndSkip(blockSum);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private byte[] readChunk(int bytes) throws IOException {
        byte[] chunkBytes = new byte[bytes];
        long actuallyRead = super.read(chunkBytes, 0, bytes);
        if (actuallyRead != (long)bytes) {
            throw new IOException("Can't read. " + bytes + "/" + actuallyRead);
        }
        return chunkBytes;
    }

    private boolean isPointerInsideEncryptedSection() {
        return this.pseudoPos - (long)this.pointerInsideDecryptedSection >= this.encryptedStartOffset && this.pseudoPos - (long)this.pointerInsideDecryptedSection < this.encryptedEndOffset;
    }

    private boolean isEndPositionInsideEncryptedSection(long requestedBytesCount) {
        return this.pseudoPos - (long)this.pointerInsideDecryptedSection + requestedBytesCount >= this.encryptedStartOffset && this.pseudoPos - (long)this.pointerInsideDecryptedSection + requestedBytesCount < this.encryptedEndOffset;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.isPointerInsideEncryptedSection()) {
            long realCountOfBytesToSkip = n - (long)(512 - this.pointerInsideDecryptedSection);
            if (realCountOfBytesToSkip <= 0L) {
                this.pseudoPos += n;
                this.pointerInsideDecryptedSection = (int)((long)this.pointerInsideDecryptedSection + n);
                return n;
            }
            if (this.isEndPositionInsideEncryptedSection(n)) {
                log.trace("4.1. Pointer Inside + End Position Inside Encrypted Section (" + this.pseudoPos + "-" + (this.pseudoPos + n) + ")");
                long blocksToSkipCountingFromStart = (this.pseudoPos + n - this.encryptedStartOffset) / 512L;
                this.resetAndSkip(blocksToSkipCountingFromStart);
                long leftovers = realCountOfBytesToSkip % 512L;
                long bytesToSkipTillRequiredBlock = realCountOfBytesToSkip - leftovers;
                this.skipLoop(bytesToSkipTillRequiredBlock);
                this.fillDecryptedCache();
                this.pseudoPos += n;
                this.pointerInsideDecryptedSection = (int)leftovers;
                return n;
            }
            log.trace("4. Pointer Inside + End Position Outside Encrypted Section (" + this.pseudoPos + "-" + (this.pseudoPos + n) + ")");
            this.skipLoop(realCountOfBytesToSkip);
            this.pseudoPos += n;
            this.pointerInsideDecryptedSection = 0;
            return n;
        }
        if (this.isEndPositionInsideEncryptedSection(n)) {
            log.trace("5. End Position Inside Encrypted Section (" + this.pseudoPos + "-" + (this.pseudoPos + n) + ")");
            long bytesToSkipTillEncryptedBlock = this.encryptedStartOffset - this.pseudoPos;
            long blocksToSkipCountingFromStart = (n - bytesToSkipTillEncryptedBlock) / 512L;
            long bytesToSkipTillRequiredBlock = bytesToSkipTillEncryptedBlock + blocksToSkipCountingFromStart * 512L;
            long leftovers = n - bytesToSkipTillRequiredBlock;
            long skipped = super.skip(bytesToSkipTillRequiredBlock);
            if (bytesToSkipTillRequiredBlock != skipped) {
                throw new IOException("Can't skip bytes. To skip: " + bytesToSkipTillEncryptedBlock + ".\nActually skipped: " + skipped + ".\nLeftovers inside encrypted section: " + leftovers);
            }
            log.trace("\tBlocks skipped " + blocksToSkipCountingFromStart);
            this.resetAndSkip(blocksToSkipCountingFromStart);
            this.fillDecryptedCache();
            this.pseudoPos += n;
            this.pointerInsideDecryptedSection = (int)leftovers;
            return n;
        }
        log.trace("6. Not encrypted (" + this.pseudoPos + "-" + (this.pseudoPos + n) + ")");
        this.skipLoop(n);
        this.pseudoPos += n;
        this.pointerInsideDecryptedSection = 0;
        return n;
    }

    private void skipLoop(long size) throws IOException {
        long mustSkip = size;
        long skipped = 0L;
        while (mustSkip > 0L) {
            mustSkip = size - (skipped += super.skip(mustSkip));
            log.trace("Skip loop: skipped: " + skipped + "\tmustSkip " + mustSkip);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) != -1) {
            return b[0];
        }
        return -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Not supported");
    }
}

