/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.aesctr;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import libKonogonka.aesctr.AesCtrBufferedInputStream;
import libKonogonka.aesctr.AesCtrDecryptForMediaBlocks;
import libKonogonka.aesctr.IProducer;

public class InFileStreamProducer
implements IProducer {
    private boolean encrypted;
    private final File file;
    private final long initialOffset;
    private final long subOffset;
    private AesCtrDecryptForMediaBlocks decryptor;
    private long mediaStartOffset;
    private long mediaEndOffset;

    public InFileStreamProducer(File file) {
        this.file = file;
        this.initialOffset = 0L;
        this.subOffset = 0L;
    }

    public InFileStreamProducer(File file, long subOffset) {
        this.file = file;
        this.initialOffset = 0L;
        this.subOffset = subOffset;
    }

    public InFileStreamProducer(File file, long initialOffset, long subOffset, AesCtrDecryptForMediaBlocks decryptor, long mediaStartOffset, long mediaEndOffset) {
        this.encrypted = decryptor != null;
        this.file = file;
        this.initialOffset = initialOffset;
        this.subOffset = subOffset;
        this.decryptor = decryptor;
        this.mediaStartOffset = mediaStartOffset;
        this.mediaEndOffset = mediaEndOffset;
    }

    @Override
    public BufferedInputStream produce() throws Exception {
        if (this.encrypted) {
            return this.produceAesCtr();
        }
        return this.produceNotEncrypted();
    }

    private AesCtrBufferedInputStream produceAesCtr() throws Exception {
        this.decryptor.reset();
        AesCtrBufferedInputStream stream = new AesCtrBufferedInputStream(this.decryptor, this.initialOffset, this.mediaStartOffset, this.mediaEndOffset, Files.newInputStream(this.file.toPath(), new OpenOption[0]), Files.size(this.file.toPath()));
        this.skipBytesTillBeginning(stream, this.subOffset);
        return stream;
    }

    private BufferedInputStream produceNotEncrypted() throws Exception {
        BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        this.skipBytesTillBeginning(stream, this.subOffset);
        return stream;
    }

    @Override
    public InFileStreamProducer getSuccessor(long subOffset) {
        return new InFileStreamProducer(this.file, this.initialOffset, subOffset, this.decryptor, this.mediaStartOffset, this.mediaEndOffset);
    }

    @Override
    public boolean isEncrypted() {
        return this.encrypted;
    }

    private void skipBytesTillBeginning(BufferedInputStream stream, long size) throws Exception {
        long mustSkip = size;
        long skipped = 0L;
        while (mustSkip > 0L) {
            mustSkip = size - (skipped += stream.skip(mustSkip));
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.getName();
    }
}

