/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NPDM.ACI0;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.fs.NPDM.ACI0.FSAccessHeaderProvider;
import libKonogonka.fs.NPDM.KernelAccessControlProvider;
import libKonogonka.fs.NPDM.ServiceAccessControlProvider;

public class ACI0Provider {
    private final String magicNum;
    private final byte[] reserved1;
    private final byte[] titleID;
    private final byte[] reserved2;
    private final int fsAccessHeaderOffset;
    private final int fsAccessHeaderSize;
    private final int serviceAccessControlOffset;
    private final int serviceAccessControlSize;
    private final int kernelAccessControlOffset;
    private final int kernelAccessControlSize;
    private final byte[] reserved3;
    private final FSAccessHeaderProvider fsAccessHeaderProvider;
    private final ServiceAccessControlProvider serviceAccessControlProvider;
    private final KernelAccessControlProvider kernelAccessControlProvider;

    public ACI0Provider(byte[] aci0bytes) throws Exception {
        if (aci0bytes.length < 64) {
            throw new Exception("ACI0 size is too short");
        }
        this.magicNum = new String(aci0bytes, 0, 4, StandardCharsets.UTF_8);
        this.reserved1 = Arrays.copyOfRange(aci0bytes, 4, 16);
        this.titleID = Arrays.copyOfRange(aci0bytes, 16, 24);
        this.reserved2 = Arrays.copyOfRange(aci0bytes, 24, 32);
        this.fsAccessHeaderOffset = Converter.getLEint(aci0bytes, 32);
        this.fsAccessHeaderSize = Converter.getLEint(aci0bytes, 36);
        this.serviceAccessControlOffset = Converter.getLEint(aci0bytes, 40);
        this.serviceAccessControlSize = Converter.getLEint(aci0bytes, 44);
        this.kernelAccessControlOffset = Converter.getLEint(aci0bytes, 48);
        this.kernelAccessControlSize = Converter.getLEint(aci0bytes, 52);
        this.reserved3 = Arrays.copyOfRange(aci0bytes, 56, 64);
        this.fsAccessHeaderProvider = new FSAccessHeaderProvider(Arrays.copyOfRange(aci0bytes, this.fsAccessHeaderOffset, this.fsAccessHeaderOffset + this.fsAccessHeaderSize));
        this.serviceAccessControlProvider = new ServiceAccessControlProvider(Arrays.copyOfRange(aci0bytes, this.serviceAccessControlOffset, this.serviceAccessControlOffset + this.serviceAccessControlSize));
        this.kernelAccessControlProvider = new KernelAccessControlProvider(Arrays.copyOfRange(aci0bytes, this.kernelAccessControlOffset, this.kernelAccessControlOffset + this.kernelAccessControlSize));
    }

    public String getMagicNum() {
        return this.magicNum;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getTitleID() {
        return this.titleID;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public int getFsAccessHeaderOffset() {
        return this.fsAccessHeaderOffset;
    }

    public int getFsAccessHeaderSize() {
        return this.fsAccessHeaderSize;
    }

    public int getServiceAccessControlOffset() {
        return this.serviceAccessControlOffset;
    }

    public int getServiceAccessControlSize() {
        return this.serviceAccessControlSize;
    }

    public int getKernelAccessControlOffset() {
        return this.kernelAccessControlOffset;
    }

    public int getKernelAccessControlSize() {
        return this.kernelAccessControlSize;
    }

    public byte[] getReserved3() {
        return this.reserved3;
    }

    public FSAccessHeaderProvider getFsAccessHeaderProvider() {
        return this.fsAccessHeaderProvider;
    }

    public ServiceAccessControlProvider getServiceAccessControlProvider() {
        return this.serviceAccessControlProvider;
    }

    public KernelAccessControlProvider getKernelAccessControlProvider() {
        return this.kernelAccessControlProvider;
    }
}

