/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.nxdumptool;

import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.nxdumptool.NxdtUsbAbi1;
import nsusbloader.com.usb.UsbConnect;
import org.usb4java.DeviceHandle;

public class NxdtTask
extends CancellableRunnable {
    private final ILogPrinter logPrinter = Log.getPrinter(EModule.NXDT);
    private final String saveToLocation;

    public NxdtTask(String saveToLocation) {
        this.saveToLocation = saveToLocation;
    }

    @Override
    public void run() {
        this.print("Save to location: " + this.saveToLocation, EMsgType.INFO);
        this.print("=============== nxdumptool ===============", EMsgType.INFO);
        UsbConnect usbConnect = UsbConnect.connectHomebrewMode(this.logPrinter);
        if (!usbConnect.isConnected()) {
            this.logPrinter.close();
            return;
        }
        DeviceHandle handler = usbConnect.getNsHandler();
        try {
            new NxdtUsbAbi1(handler, this.logPrinter, this.saveToLocation, this);
        }
        catch (Exception e) {
            this.print(e.getMessage(), EMsgType.FAIL);
        }
        this.print(".:: Complete ::.", EMsgType.PASS);
        usbConnect.close();
        this.logPrinter.updateOneLinerStatus(true);
        this.logPrinter.close();
    }

    private void print(String message, EMsgType type) {
        try {
            this.logPrinter.print(message, type);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

