/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libKonogonka.Converter;

public class SimplyFind {
    private String what;
    private final byte[] where;
    private Matcher matcherHex;
    private Matcher matcherDot;
    private final List<Integer> findings = new ArrayList<Integer>();
    private final int statementLength;
    private final List<SearchBlock> searchBlocks = new ArrayList<SearchBlock>();

    public SimplyFind(String what, byte[] where) {
        this.where = where;
        if (!what.contains(".")) {
            this.doKMPSearch(Converter.hexStringToByteArray(what), 0);
            this.statementLength = what.length() / 2;
            return;
        }
        this.what = what.replaceAll("\\.", "\\.\\.");
        this.statementLength = this.what.length() / 2;
        this.buildSearchingSequence();
        this.complexSearch();
    }

    private void buildSearchingSequence() {
        int nextHexPos;
        Pattern patternHex = Pattern.compile("[0-9]|[A-F]|[a-f]");
        Pattern patternDot = Pattern.compile("\\.");
        this.matcherHex = patternHex.matcher(this.what);
        this.matcherDot = patternDot.matcher(this.what);
        int nextDotPos = 0;
        while ((nextHexPos = this.getNextNumberPosition(nextDotPos)) != -1) {
            nextDotPos = this.getNextDotPosition(nextHexPos);
            if (nextDotPos == -1) {
                this.searchBlocks.add(new SearchBlock(this.what.substring(nextHexPos), nextHexPos));
                break;
            }
            String searchStatement = this.what.substring(nextHexPos, nextDotPos);
            this.searchBlocks.add(new SearchBlock(searchStatement, nextHexPos));
        }
    }

    private int getNextNumberPosition(int since) {
        if (this.matcherHex.find(since)) {
            return this.matcherHex.start();
        }
        return -1;
    }

    private int getNextDotPosition(int since) {
        if (this.matcherDot.find(since)) {
            return this.matcherDot.start();
        }
        return -1;
    }

    private void complexSearch() {
        SearchBlock block = this.searchBlocks.get(0);
        this.doKMPSearch(block.statement, block.offsetInStatement);
        this.findings.removeIf(this::searchForward);
    }

    private boolean searchForward(int offset) {
        for (int i = 1; i < this.searchBlocks.size(); ++i) {
            SearchBlock block = this.searchBlocks.get(i);
            if (this.doDumbSearch(block.statement, offset + block.offsetInStatement)) continue;
            return true;
        }
        return false;
    }

    private void doKMPSearch(byte[] subject, int skip) {
        int i;
        int whereSize = this.where.length;
        int subjectSize = subject.length;
        int[] pf = new int[subjectSize];
        int j = 0;
        for (i = 1; i < subjectSize; ++i) {
            while (j > 0 && subject[j] != subject[i]) {
                j = pf[j - 1];
            }
            if (subject[j] == subject[i]) {
                // empty if block
            }
            pf[i] = ++j;
        }
        j = 0;
        for (i = 0; i < whereSize; ++i) {
            while (j > 0 && subject[j] != this.where[i]) {
                j = pf[j - 1];
            }
            if (subject[j] == this.where[i]) {
                ++j;
            }
            if (j != subjectSize) continue;
            this.findings.add(i - j + 1 - skip);
            j = 0;
        }
    }

    private boolean doDumbSearch(byte[] subject, int since) {
        for (int i = 0; i < subject.length; ++i) {
            if (this.where[since + i] == subject[i]) continue;
            return false;
        }
        return true;
    }

    public int getStatementLength() {
        return this.statementLength;
    }

    public List<Integer> getResults() {
        return this.findings;
    }

    private static class SearchBlock {
        byte[] statement;
        int offsetInStatement;

        SearchBlock(String statement, int offset) {
            if (statement != null) {
                this.statement = Converter.hexStringToByteArray(statement);
            }
            this.offsetInStatement = offset / 2;
        }
    }
}

