/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nsusbloader.cli.IncorrectSetupException;
import nsusbloader.com.usb.UsbCommunications;

public class TinfoilUsbCli {
    private final String[] arguments;
    private List<File> filesList;

    TinfoilUsbCli(String[] arguments) throws InterruptedException, IncorrectSetupException {
        this.arguments = arguments;
        this.checkArguments();
        this.parseFilesArguments();
        this.runTinfoilBackend();
    }

    private void checkArguments() throws IncorrectSetupException {
        if (this.arguments == null || this.arguments.length == 0) {
            throw new IncorrectSetupException("No files?\nTry 'ns-usbloader -h' for more information.");
        }
    }

    private void parseFilesArguments() throws IncorrectSetupException {
        this.filesList = new ArrayList<File>();
        for (String arg : this.arguments) {
            File file = new File(arg);
            if (!file.exists()) continue;
            this.filesList.add(file);
        }
        if (this.filesList.size() == 0) {
            throw new IncorrectSetupException("File(s) doesn't exist.\nTry 'ns-usbloader -n help' for more information.");
        }
    }

    private void runTinfoilBackend() throws InterruptedException {
        UsbCommunications task = new UsbCommunications(this.filesList, "TinFoil", false);
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        thread.join();
    }
}

