/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import libKonogonka.aesctr.AesCtrDecryptClassic;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class System2Header {
    private static final Logger log = LogManager.getLogger(System2Header.class);
    private final byte[] headerCtr;
    private final long packageSize;
    private byte[] section0Ctr;
    private byte[] section1Ctr;
    private byte[] section2Ctr;
    private byte[] section3Ctr;
    private String magic;
    private int baseOffset;
    private byte[] zeroOrReserved;
    private byte package2Version;
    private byte bootloaderVersion;
    private byte[] padding;
    private int section0size;
    private int section1size;
    private int section2size;
    private int section3size;
    private int section0offset;
    private int section1offset;
    private int section2offset;
    private int section3offset;
    private byte[] sha256overEncryptedSection0;
    private byte[] sha256overEncryptedSection1;
    private byte[] sha256overEncryptedSection2;
    private byte[] sha256overEncryptedSection3;
    private String key;
    private HashMap<String, String> package2Keys;
    private byte[] decodedHeaderBytes;

    public System2Header(byte[] headerBytes, HashMap<String, String> keys) throws Exception {
        this.headerCtr = Arrays.copyOfRange(headerBytes, 0, 16);
        this.packageSize = Converter.getLEint(this.headerCtr, 0) ^ Converter.getLEint(this.headerCtr, 8) ^ Converter.getLEint(this.headerCtr, 12);
        this.collectKeys(keys);
        this.decodeEncrypted(headerBytes);
        this.buildHeader();
    }

    private void collectKeys(HashMap<String, String> keys) {
        this.package2Keys = new HashMap();
        for (String key : keys.keySet()) {
            if (!key.matches("package2_key_[0-f][0-f]")) continue;
            this.package2Keys.put(key, keys.get(key));
        }
    }

    private void decodeEncrypted(byte[] headerBytes) throws Exception {
        for (Map.Entry<String, String> entry : this.package2Keys.entrySet()) {
            AesCtrDecryptClassic ctrClassic = new AesCtrDecryptClassic(entry.getValue(), this.headerCtr);
            this.decodedHeaderBytes = ctrClassic.decryptNext(headerBytes);
            byte[] magicBytes = Arrays.copyOfRange(this.decodedHeaderBytes, 80, 84);
            this.magic = new String(magicBytes, StandardCharsets.US_ASCII);
            if (!this.magic.equals("PK21")) continue;
            this.key = entry.getValue();
            log.debug("Header key used " + entry.getKey() + " = " + entry.getValue());
            return;
        }
        throw new Exception("Header hasn't been decoded. No appropriate package2_key_XX?");
    }

    private void buildHeader() {
        this.section0Ctr = Arrays.copyOfRange(this.decodedHeaderBytes, 16, 32);
        this.section1Ctr = Arrays.copyOfRange(this.decodedHeaderBytes, 32, 48);
        this.section2Ctr = Arrays.copyOfRange(this.decodedHeaderBytes, 48, 64);
        this.section3Ctr = Arrays.copyOfRange(this.decodedHeaderBytes, 64, 80);
        this.baseOffset = Converter.getLEint(this.decodedHeaderBytes, 84);
        this.zeroOrReserved = Arrays.copyOfRange(this.decodedHeaderBytes, 88, 92);
        this.package2Version = this.decodedHeaderBytes[92];
        this.bootloaderVersion = this.decodedHeaderBytes[93];
        this.padding = Arrays.copyOfRange(this.decodedHeaderBytes, 94, 96);
        this.section0size = Converter.getLEint(this.decodedHeaderBytes, 96);
        this.section1size = Converter.getLEint(this.decodedHeaderBytes, 100);
        this.section2size = Converter.getLEint(this.decodedHeaderBytes, 104);
        this.section3size = Converter.getLEint(this.decodedHeaderBytes, 108);
        this.section0offset = Converter.getLEint(this.decodedHeaderBytes, 112);
        this.section1offset = Converter.getLEint(this.decodedHeaderBytes, 116);
        this.section2offset = Converter.getLEint(this.decodedHeaderBytes, 120);
        this.section3offset = Converter.getLEint(this.decodedHeaderBytes, 124);
        this.sha256overEncryptedSection0 = Arrays.copyOfRange(this.decodedHeaderBytes, 128, 160);
        this.sha256overEncryptedSection1 = Arrays.copyOfRange(this.decodedHeaderBytes, 160, 192);
        this.sha256overEncryptedSection2 = Arrays.copyOfRange(this.decodedHeaderBytes, 192, 224);
        this.sha256overEncryptedSection3 = Arrays.copyOfRange(this.decodedHeaderBytes, 224, 256);
        if (this.packageSize != (long)(512 + this.section0size)) {
            log.error("'Package size' doesn't match 'Header Size' + 'Section 0 size'!");
        }
    }

    public byte[] getHeaderCtr() {
        return this.headerCtr;
    }

    public long getPackageSize() {
        return this.packageSize;
    }

    public byte[] getSection0Ctr() {
        return this.section0Ctr;
    }

    public byte[] getSection1Ctr() {
        return this.section1Ctr;
    }

    public byte[] getSection2Ctr() {
        return this.section2Ctr;
    }

    public byte[] getSection3Ctr() {
        return this.section3Ctr;
    }

    public String getMagic() {
        return this.magic;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public byte[] getZeroOrReserved() {
        return this.zeroOrReserved;
    }

    public byte getPackage2Version() {
        return this.package2Version;
    }

    public byte getBootloaderVersion() {
        return this.bootloaderVersion;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public int getSection0size() {
        return this.section0size;
    }

    public int getSection1size() {
        return this.section1size;
    }

    public int getSection2size() {
        return this.section2size;
    }

    public int getSection3size() {
        return this.section3size;
    }

    public int getSection0offset() {
        return this.section0offset;
    }

    public int getSection1offset() {
        return this.section1offset;
    }

    public int getSection2offset() {
        return this.section2offset;
    }

    public int getSection3offset() {
        return this.section3offset;
    }

    public byte[] getSha256overEncryptedSection0() {
        return this.sha256overEncryptedSection0;
    }

    public byte[] getSha256overEncryptedSection1() {
        return this.sha256overEncryptedSection1;
    }

    public byte[] getSha256overEncryptedSection2() {
        return this.sha256overEncryptedSection2;
    }

    public byte[] getSha256overEncryptedSection3() {
        return this.sha256overEncryptedSection3;
    }

    public String getKey() {
        return this.key;
    }

    public void printDebug() {
        log.debug("== System2 Header ==\nHeader CTR          : " + Converter.byteArrToHexStringAsLE(this.headerCtr) + "\n  Package size      : " + RainbowDump.formatDecHexString(this.packageSize) + "\nSection 0 CTR       : " + Converter.byteArrToHexStringAsLE(this.section0Ctr) + "\nSection 1 CTR       : " + Converter.byteArrToHexStringAsLE(this.section1Ctr) + "\nSection 2 CTR       : " + Converter.byteArrToHexStringAsLE(this.section2Ctr) + "\nSection 3 CTR       : " + Converter.byteArrToHexStringAsLE(this.section3Ctr) + "\nMagic PK21          : " + this.magic + "\nOffset              : " + RainbowDump.formatDecHexString(this.baseOffset) + "\nZero/reserved       : " + Converter.byteArrToHexStringAsLE(this.zeroOrReserved) + "\nPackage2 version    : " + RainbowDump.formatDecHexString(this.package2Version) + "\nBootloader version  : " + RainbowDump.formatDecHexString(this.bootloaderVersion) + "\nPadding             : " + Converter.byteArrToHexStringAsLE(this.padding) + "\nSection 0 size      : " + RainbowDump.formatDecHexString(this.section0size) + "\nSection 1 size      : " + RainbowDump.formatDecHexString(this.section1size) + "\nSection 2 size      : " + RainbowDump.formatDecHexString(this.section2size) + "\nSection 3 size      : " + RainbowDump.formatDecHexString(this.section3size) + "\nSection 0 offset    : " + RainbowDump.formatDecHexString(this.section0offset) + "\nSection 1 offset    : " + RainbowDump.formatDecHexString(this.section1offset) + "\nSection 2 offset    : " + RainbowDump.formatDecHexString(this.section2offset) + "\nSection 3 offset    : " + RainbowDump.formatDecHexString(this.section3offset) + "\nSHA256 ov.enc.sec 0 : " + Converter.byteArrToHexStringAsLE(this.sha256overEncryptedSection0) + "\nSHA256 ov.enc.sec 1 : " + Converter.byteArrToHexStringAsLE(this.sha256overEncryptedSection1) + "\nSHA256 ov.enc.sec 2 : " + Converter.byteArrToHexStringAsLE(this.sha256overEncryptedSection2) + "\nSHA256 ov.enc.sec 3 : " + Converter.byteArrToHexStringAsLE(this.sha256overEncryptedSection3) + "\n");
    }
}

