/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2.ini1;

import java.nio.file.Paths;
import libKonogonka.aesctr.InFileStreamClassicProducer;
import libKonogonka.fs.ExportAble;
import libKonogonka.fs.other.System2.ini1.KIP1Header;
import libKonogonka.fs.other.System2.ini1.KIP1Raw;
import libKonogonka.fs.other.System2.ini1.Kip1Unpacker;

public class KIP1Provider
extends ExportAble {
    public static final int HEADER_SIZE = 256;
    private KIP1Header header;
    private final InFileStreamClassicProducer producer;
    private long startOffset;
    private long endOffset;
    private long size;

    public KIP1Provider(String fileLocation) throws Exception {
        this(fileLocation, 0L);
    }

    public KIP1Provider(String fileLocation, long kip1StartOffset) throws Exception {
        this.producer = new InFileStreamClassicProducer(Paths.get(fileLocation, new String[0]));
        this.stream = this.producer.produce();
        if (kip1StartOffset != this.stream.skip(kip1StartOffset)) {
            throw new Exception("Failed to skip declared starting offset " + kip1StartOffset);
        }
        byte[] kip1HeaderBytes = new byte[256];
        if (256 != this.stream.read(kip1HeaderBytes)) {
            throw new Exception("Unable to read KIP1 file header");
        }
        this.makeHeader(kip1HeaderBytes);
        this.calculateOffsets(kip1StartOffset);
    }

    public KIP1Provider(byte[] kip1HeaderBytes, long kip1StartOffset, InFileStreamClassicProducer producer) throws Exception {
        this.makeHeader(kip1HeaderBytes);
        this.calculateOffsets(kip1StartOffset);
        this.producer = producer;
        this.stream = producer.produce();
    }

    private void makeHeader(byte[] kip1HeaderBytes) throws Exception {
        this.header = new KIP1Header(kip1HeaderBytes);
    }

    private void calculateOffsets(long kip1StartOffset) {
        this.startOffset = kip1StartOffset;
        this.endOffset = 256L + kip1StartOffset + (long)this.header.getTextSegmentHeader().getSize() + (long)this.header.getRoDataSegmentHeader().getSize() + (long)this.header.getRwDataSegmentHeader().getSize() + (long)this.header.getBssSegmentHeader().getSize();
        this.size = this.endOffset - this.startOffset;
    }

    public KIP1Header getHeader() {
        return this.header;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getSize() {
        return this.size;
    }

    public boolean export(String saveTo) throws Exception {
        this.stream = this.producer.produce();
        return this.export(saveTo, this.header.getName() + ".kip1", this.startOffset, this.size);
    }

    public InFileStreamClassicProducer getStreamProducer() throws Exception {
        return this.producer.getSuccessor(this.startOffset, true);
    }

    public boolean exportAsDecompressed(String saveToLocation) throws Exception {
        return Kip1Unpacker.unpack(this.header, this.producer.getSuccessor(this.startOffset, true), saveToLocation);
    }

    public KIP1Raw getAsDecompressed() throws Exception {
        return Kip1Unpacker.getKIP1Raw(this.header, this.producer.getSuccessor(this.startOffset, true));
    }

    public void printDebug() {
        this.header.printDebug();
    }
}

