/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA.NCASectionTableBlock;

import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.fs.NCA.NCASectionTableBlock.BucketTreeHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompressionInfo {
    private static final Logger log = LogManager.getLogger(CompressionInfo.class);
    private final long offset;
    private final long size;
    private final BucketTreeHeader bktr;
    private final byte[] unknown;

    CompressionInfo(byte[] rawTable) {
        this.offset = Converter.getLElong(rawTable, 0);
        this.size = Converter.getLElong(rawTable, 8);
        this.bktr = new BucketTreeHeader(Arrays.copyOfRange(rawTable, 16, 32));
        this.unknown = Arrays.copyOfRange(rawTable, 32, 40);
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.size;
    }

    public String getBktrMagic() {
        return this.bktr.getMagic();
    }

    public int getBktrVersion() {
        return this.bktr.getVersion();
    }

    public int getBktrEntryCount() {
        return this.bktr.getEntryCount();
    }

    public byte[] getBktrUnknown() {
        return this.bktr.getUnknown();
    }

    public byte[] getUnknown() {
        return this.unknown;
    }

    public void printDebug() {
        log.debug("CompressionInfo:\nOffset    : " + this.offset + "\nSize      : " + this.size + "\n");
        this.bktr.printDebug();
        log.debug("\nUnknown   : " + Converter.byteArrToHexStringAsLE(this.unknown));
    }
}

