/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NSO;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import libKonogonka.fs.NSO.SegmentHeader;
import libKonogonka.fs.NSO.SegmentHeaderRelative;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NSO0Header {
    private static final Logger log = LogManager.getLogger(NSO0Header.class);
    private String magic;
    private int version;
    private byte[] upperReserved;
    private int flags;
    private SegmentHeader textSegmentHeader;
    private int moduleNameOffset;
    private SegmentHeader rodataSegmentHeader;
    private int moduleNameSize;
    private SegmentHeader dataSegmentHeader;
    private int bssSize;
    private byte[] moduleId;
    private int textCompressedSize;
    private int rodataCompressedSize;
    private int dataCompressedSize;
    private byte[] bottomReserved;
    private SegmentHeaderRelative _api_infoRelative;
    private SegmentHeaderRelative _dynstrRelative;
    private SegmentHeaderRelative _dynsymRelative;
    private byte[] textHash;
    private byte[] rodataHash;
    private byte[] dataHash;

    public NSO0Header(byte[] headerBytes) throws Exception {
        if (headerBytes.length < 256) {
            throw new Exception("Incorrect NSO0 header size");
        }
        this.parse(headerBytes);
    }

    private void parse(byte[] knownStartingBytes) throws Exception {
        this.magic = new String(knownStartingBytes, 0, 4, StandardCharsets.US_ASCII);
        if (!this.magic.equals("NSO0")) {
            throw new Exception("Bad magic");
        }
        this.version = Converter.getLEint(knownStartingBytes, 4);
        this.upperReserved = Arrays.copyOfRange(knownStartingBytes, 8, 12);
        this.flags = Converter.getLEint(knownStartingBytes, 12);
        this.textSegmentHeader = new SegmentHeader(knownStartingBytes, 16);
        this.moduleNameOffset = Converter.getLEint(knownStartingBytes, 28);
        this.rodataSegmentHeader = new SegmentHeader(knownStartingBytes, 32);
        this.moduleNameSize = Converter.getLEint(knownStartingBytes, 44);
        this.dataSegmentHeader = new SegmentHeader(knownStartingBytes, 48);
        this.bssSize = Converter.getLEint(knownStartingBytes, 60);
        this.moduleId = Arrays.copyOfRange(knownStartingBytes, 64, 96);
        this.textCompressedSize = Converter.getLEint(knownStartingBytes, 96);
        this.rodataCompressedSize = Converter.getLEint(knownStartingBytes, 100);
        this.dataCompressedSize = Converter.getLEint(knownStartingBytes, 104);
        this.bottomReserved = Arrays.copyOfRange(knownStartingBytes, 108, 136);
        this._api_infoRelative = new SegmentHeaderRelative(knownStartingBytes, 136);
        this._dynstrRelative = new SegmentHeaderRelative(knownStartingBytes, 144);
        this._dynsymRelative = new SegmentHeaderRelative(knownStartingBytes, 152);
        this.textHash = Arrays.copyOfRange(knownStartingBytes, 160, 192);
        this.rodataHash = Arrays.copyOfRange(knownStartingBytes, 192, 224);
        this.dataHash = Arrays.copyOfRange(knownStartingBytes, 224, 256);
    }

    public String getMagic() {
        return this.magic;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getUpperReserved() {
        return this.upperReserved;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isTextCompressFlag() {
        return (this.flags & 1) == 1;
    }

    public boolean isRoCompressFlag() {
        return (this.flags & 2) >> 1 == 1;
    }

    public boolean isDataCompressFlag() {
        return (this.flags & 4) >> 2 == 1;
    }

    public boolean isTextHashFlag() {
        return (this.flags & 8) >> 3 == 1;
    }

    public boolean isRoHashFlag() {
        return (this.flags & 0x10) >> 4 == 1;
    }

    public boolean isDataHashFlag() {
        return (this.flags & 0x20) >> 5 == 1;
    }

    public SegmentHeader getTextSegmentHeader() {
        return this.textSegmentHeader;
    }

    public int getModuleNameOffset() {
        return this.moduleNameOffset;
    }

    public SegmentHeader getRodataSegmentHeader() {
        return this.rodataSegmentHeader;
    }

    public int getModuleNameSize() {
        return this.moduleNameSize;
    }

    public SegmentHeader getDataSegmentHeader() {
        return this.dataSegmentHeader;
    }

    public int getBssSize() {
        return this.bssSize;
    }

    public byte[] getModuleId() {
        return this.moduleId;
    }

    public int getTextCompressedSize() {
        return this.textCompressedSize;
    }

    public int getRodataCompressedSize() {
        return this.rodataCompressedSize;
    }

    public int getDataCompressedSize() {
        return this.dataCompressedSize;
    }

    public byte[] getBottomReserved() {
        return this.bottomReserved;
    }

    public SegmentHeaderRelative get_api_infoRelative() {
        return this._api_infoRelative;
    }

    public SegmentHeaderRelative get_dynstrRelative() {
        return this._dynstrRelative;
    }

    public SegmentHeaderRelative get_dynsymRelative() {
        return this._dynsymRelative;
    }

    public byte[] getTextHash() {
        return this.textHash;
    }

    public byte[] getRodataHash() {
        return this.rodataHash;
    }

    public byte[] getDataHash() {
        return this.dataHash;
    }

    public void printDebug() {
        log.debug(".:: NSO0 Provider ::.\n ============================================================= \nMagic \"NSO0\"                                     " + this.magic + "\nVersion (always 0)                               " + this.version + "\nReserved                                         " + Converter.byteArrToHexStringAsLE(this.upperReserved) + "\nFlags                                            " + Converter.intToBinaryString(this.flags) + "\n  |- 0.   .text Compress                         " + this.isTextCompressFlag() + "\n  |- 1.   .rodata Compress                       " + this.isRoCompressFlag() + "\n  |- 2.   .data Compress                         " + this.isDataCompressFlag() + "\n  |- 3.   .text Hash                             " + this.isTextHashFlag() + "\n  |- 4.   .rodata Hash                           " + this.isRoHashFlag() + "\n  |- 5.   .data Hash                             " + this.isDataHashFlag() + "\n                                     +++\nSegmentHeader for .text\n    |-  File Offset - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this.textSegmentHeader.getSegmentOffset()) + "\n    |-  Memory Offset - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this.textSegmentHeader.getMemoryOffset()) + "\n    |-  Size As Decompressed  - - - - - - - - -  " + RainbowDump.formatDecHexString(this.textSegmentHeader.getSize()) + "\nModuleNameOffset (calculated by sizeof(header))  " + RainbowDump.formatDecHexString(this.moduleNameOffset) + "\n                                     +++\nSegmentHeader for .rodata\n    |-  File Offset - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this.rodataSegmentHeader.getSegmentOffset()) + "\n    |-  Memory Offset - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this.rodataSegmentHeader.getMemoryOffset()) + "\n    |-  Size As Decompressed  - - - - - - - - -  " + RainbowDump.formatDecHexString(this.rodataSegmentHeader.getSize()) + "\nModuleNameSize                                   " + RainbowDump.formatDecHexString(this.moduleNameSize) + "\n                                     +++\nSegmentHeader for .data\n    |-  File Offset - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this.dataSegmentHeader.getSegmentOffset()) + "\n    |-  Memory Offset - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this.dataSegmentHeader.getMemoryOffset()) + "\n    |-  Size As Decompressed  - - - - - - - - -  " + RainbowDump.formatDecHexString(this.dataSegmentHeader.getSize()) + "\n  .bss Size                                      " + RainbowDump.formatDecHexString(this.bssSize) + "\nModule ID (aka Build ID)                         " + Converter.byteArrToHexStringAsLE(this.moduleId) + "\n  .text Size (compressed)                        " + RainbowDump.formatDecHexString(this.textCompressedSize) + "\n  .rodata Size (compressed)                      " + RainbowDump.formatDecHexString(this.rodataCompressedSize) + "\n  .data Size (compressed)                        " + RainbowDump.formatDecHexString(this.dataCompressedSize) + "\nReserved                                         " + Converter.byteArrToHexStringAsLE(this.bottomReserved) + "\n                                     xxx\nSegmentHeaderRelative for .api_info\n    |-  Offset  - - - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this._api_infoRelative.getOffset()) + "\n    |-  Size  - - - - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this._api_infoRelative.getSize()) + "\n                                     xxx\nSegmentHeaderRelative for .dynstr\n    |-  Offset  - - - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this._dynstrRelative.getOffset()) + "\n    |-  Size  - - - - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this._dynstrRelative.getSize()) + "\n                                     xxx\nSegmentHeaderRelative for .dynsym\n    |-  Offset  - - - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this._dynsymRelative.getOffset()) + "\n    |-  Size  - - - - - - - - - - - - - - - - -  " + RainbowDump.formatDecHexString(this._dynsymRelative.getSize()) + "\n                                     xxx\n.text decompressed' SHA-256 hash                 " + Converter.byteArrToHexStringAsLE(this.textHash) + "\n.rodata decompressed' SHA-256 hash               " + Converter.byteArrToHexStringAsLE(this.rodataHash) + "\n.data decompressed' SHA-256 hash                 " + Converter.byteArrToHexStringAsLE(this.dataHash) + "\n ============================================================= ");
    }
}

