/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import nsusbloader.AppPreferences;
import nsusbloader.MediatorControl;

public class FontSettingsController
implements Initializable {
    private final AppPreferences preferences = AppPreferences.getInstance();
    @FXML
    private Button applyBtn;
    @FXML
    private Button cancelBtn;
    @FXML
    private Button resetBtn;
    @FXML
    private ListView<String> fontsLv;
    @FXML
    private Spinner<Double> fontSizeSpinner;
    @FXML
    private Text exampleText;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.applyBtn.setDefaultButton(true);
        this.applyBtn.getStyleClass().add("buttonUp");
        this.applyBtn.setOnAction(e -> this.applyChanges());
        this.cancelBtn.setCancelButton(true);
        this.cancelBtn.setOnAction(e -> this.closeWindow());
        this.resetBtn.setOnAction(e -> this.reset());
        this.fontsLv.setCellFactory(item -> this.getCellFactory());
        this.fontsLv.setItems(this.getFonts());
        this.fontsLv.getSelectionModel().select(this.preferences.getFontFamily());
        this.fontsLv.getSelectionModel().selectedIndexProperty().addListener((observableValue, oldValueNumber, newValueNumber) -> this.setExampleTextFont());
        this.fontsLv.setFixedCellSize(40.0);
        this.fontSizeSpinner.setEditable(false);
        this.fontSizeSpinner.setValueFactory(this.getValueFactory());
        this.exampleText.setText(resourceBundle.getString("fontPreviewText"));
        this.fontSizeSpinner.getValueFactory().setValue(this.preferences.getFontSize());
    }

    private ListCell<String> getCellFactory() {
        return new ListCell<String>(this){

            @Override
            protected void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null) {
                    return;
                }
                Font font = Font.font(item);
                Text itemText = new Text(item);
                itemText.setFont(font);
                this.setGraphic(itemText);
            }
        };
    }

    private ObservableList<String> getFonts() {
        ObservableList<String> fonts = FXCollections.observableArrayList();
        fonts.addAll((Collection<String>)Font.getFamilies());
        return fonts;
    }

    private SpinnerValueFactory<Double> getValueFactory() {
        return new SpinnerValueFactory<Double>(){

            @Override
            public void decrement(int i) {
                double value = (Double)this.getValue() - (double)i;
                if (value < 4.0) {
                    return;
                }
                this.setValue(value);
                FontSettingsController.this.setExampleTextFont(value);
            }

            @Override
            public void increment(int i) {
                double value = (Double)this.getValue() + (double)i;
                if (value > 100.0) {
                    return;
                }
                this.setValue(value);
                FontSettingsController.this.setExampleTextFont(value);
            }
        };
    }

    private void setExampleTextFont() {
        this.setExampleTextFont((String)this.fontsLv.getSelectionModel().getSelectedItem(), this.fontSizeSpinner.getValue());
    }

    private void setExampleTextFont(double size) {
        this.setExampleTextFont((String)this.fontsLv.getSelectionModel().getSelectedItem(), size);
    }

    private void setExampleTextFont(String font, double size) {
        this.exampleText.setFont(Font.font(font, size));
    }

    private void reset() {
        Font defaultFont = Font.getDefault();
        this.exampleText.setFont(defaultFont);
        this.fontsLv.getSelectionModel().select(defaultFont.getFamily());
        this.fontSizeSpinner.getValueFactory().setValue(defaultFont.getSize());
    }

    private void applyChanges() {
        String fontFamily = (String)this.fontsLv.getSelectionModel().getSelectedItem();
        double fontSize = this.fontSizeSpinner.getValue().intValue();
        this.preferences.setFontStyle(fontFamily, fontSize);
        MediatorControl.INSTANCE.getLogArea().getScene().getRoot().setStyle(String.format("-fx-font-family: \"%s\"; -fx-font-size: %.0f;", fontFamily, fontSize));
        this.closeWindow();
    }

    private void closeWindow() {
        ((Stage)this.cancelBtn.getScene().getWindow()).close();
    }
}

