/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.WindowsDrivers;

import java.io.File;
import java.util.ResourceBundle;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import nsusbloader.AppPreferences;
import nsusbloader.Utilities.WindowsDrivers.DownloadDriversTask;

public class DriversInstall {
    private static volatile boolean isRunning;
    private final ResourceBundle resourceBundle;
    private Label runInstallerStatusLabel;

    public DriversInstall(ResourceBundle rb) {
        this.resourceBundle = rb;
        if (this.isDriversDistributesWithExecutable()) {
            this.runInstaller("Drivers_set.exe");
        } else {
            this.runDownloadProcess();
        }
    }

    private boolean isDriversDistributesWithExecutable() {
        File drivers = new File("Drivers_set.exe");
        return drivers.length() == 3857375L;
    }

    private void runDownloadProcess() {
        if (isRunning) {
            return;
        }
        isRunning = true;
        DownloadDriversTask downloadTask = new DownloadDriversTask();
        Button cancelButton = new Button(this.resourceBundle.getString("btn_Cancel"));
        HBox hBoxInformation = new HBox();
        hBoxInformation.setAlignment(Pos.TOP_LEFT);
        hBoxInformation.getChildren().add(new Label(this.resourceBundle.getString("windowBodyDownloadDrivers")));
        ProgressBar progressBar = new ProgressBar();
        progressBar.setPrefWidth(Double.MAX_VALUE);
        progressBar.progressProperty().bind(downloadTask.progressProperty());
        Label downloadStatusLabel = new Label();
        downloadStatusLabel.setWrapText(true);
        downloadStatusLabel.textProperty().bind(downloadTask.messageProperty());
        this.runInstallerStatusLabel = new Label();
        this.runInstallerStatusLabel.setWrapText(true);
        Pane fillerPane1 = new Pane();
        Pane fillerPane2 = new Pane();
        VBox parentVBox = new VBox();
        parentVBox.setAlignment(Pos.TOP_CENTER);
        parentVBox.setFillWidth(true);
        parentVBox.setSpacing(5.0);
        parentVBox.setPadding(new Insets(5.0));
        parentVBox.setFillWidth(true);
        parentVBox.getChildren().addAll((Node[])new Node[]{hBoxInformation, fillerPane1, downloadStatusLabel, this.runInstallerStatusLabel, fillerPane2, progressBar, cancelButton});
        VBox.setVgrow(fillerPane1, Priority.ALWAYS);
        VBox.setVgrow(fillerPane2, Priority.ALWAYS);
        Stage stage = new Stage();
        stage.setTitle(this.resourceBundle.getString("windowTitleDownloadDrivers"));
        stage.getIcons().addAll((Image[])new Image[]{new Image("/res/dwnload_ico32x32.png"), new Image("/res/dwnload_ico48x48.png"), new Image("/res/dwnload_ico64x64.png"), new Image("/res/dwnload_ico128x128.png")});
        stage.setMinWidth(400.0);
        stage.setMinHeight(150.0);
        Scene mainScene = new Scene(parentVBox, 405.0, 155.0);
        mainScene.getStylesheets().add(AppPreferences.getInstance().getTheme());
        parentVBox.setStyle(AppPreferences.getInstance().getFontStyle());
        stage.setOnHidden(windowEvent -> {
            downloadTask.cancel(true);
            isRunning = false;
        });
        stage.setScene(mainScene);
        stage.show();
        stage.toFront();
        downloadTask.setOnSucceeded(event -> {
            cancelButton.setText(this.resourceBundle.getString("btn_Close"));
            String returnedValue = (String)downloadTask.getValue();
            if (returnedValue == null) {
                return;
            }
            if (this.runInstaller(returnedValue)) {
                stage.close();
            }
        });
        Thread downloadThread = new Thread(downloadTask);
        downloadThread.start();
        cancelButton.setOnAction(actionEvent -> {
            downloadTask.cancel(true);
            stage.close();
        });
    }

    private boolean runInstaller(String pathToFile) {
        try {
            Runtime.getRuntime().exec("cmd /c " + pathToFile);
            return true;
        }
        catch (Exception e) {
            this.runInstallerStatusLabel.setText("Error: " + String.valueOf(e));
            e.printStackTrace();
            return false;
        }
    }
}

