/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.DataConvertUtils;
import nsusbloader.com.helpers.NSSplitReader;
import nsusbloader.com.usb.TransferModule;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

class TinFoil
extends TransferModule {
    private static final int CHUNK_SIZE = 0x800000;
    private static final byte[] TUL0 = "TUL0".getBytes(StandardCharsets.UTF_8);
    private static final String MAGIC = "TUC0";
    private static final byte[] STANDARD_REPLY = new byte[]{84, 85, 67, 48, 1, 0, 0, 0, 1, 0, 0, 0};
    private static final byte[] TWELVE_ZERO_BYTES = new byte[12];
    private static final byte[] PADDING = new byte[8];
    private static final byte CMD_EXIT = 0;
    private static final byte CMD_FILE_RANGE_DEFAULT = 1;
    private static final byte CMD_FILE_RANGE_ALTERNATIVE = 2;

    TinFoil(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter logPrinter) {
        super(handler, nspMap, task, logPrinter);
        this.print("======== Awoo Installer and compatibles ========", EMsgType.INFO);
        this.workLoop();
    }

    private void workLoop() {
        try {
            this.sendListOfFiles();
            this.proceedCommands();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendListOfFiles() throws Exception {
        byte[] fileNames = this.buildFileNamesToSend();
        byte[] fileNamesSize = DataConvertUtils.intToArrLE(fileNames.length);
        this.writeUsb(TUL0, "[1/4] Send list of files: handshake");
        this.writeUsb(fileNamesSize, "[2/4] Send list of files: list length");
        this.writeUsb(PADDING, "[3/4] Send list of files: padding");
        this.writeUsb(fileNames, "[4/4] Send list of files: list itself");
        this.print("Send list of files complete.", EMsgType.PASS);
    }

    private byte[] buildFileNamesToSend() {
        StringBuilder fileNamesListBuilder = new StringBuilder();
        this.nspMap.keySet().forEach(fileName -> fileNamesListBuilder.append((String)fileName).append('\n'));
        return fileNamesListBuilder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void proceedCommands() {
        this.print("Awaiting for NS commands", EMsgType.INFO);
        try {
            while (true) {
                byte[] deviceReply;
                if (this.isInvalidReply(deviceReply = this.readUsb())) {
                    continue;
                }
                switch (deviceReply[8]) {
                    case 0: {
                        this.print("Transfer complete", EMsgType.PASS);
                        this.status = EFileStatus.UPLOADED;
                        return;
                    }
                    case 1: 
                    case 2: {
                        this.fileRangeCmd();
                    }
                }
            }
        }
        catch (ArithmeticException ae) {
            this.print("Unable to cast huge offsets to int ('offset end' - 'offsets current'):\n         " + ae.getMessage(), EMsgType.FAIL);
            ae.printStackTrace();
        }
        catch (NullPointerException npe) {
            this.print("Something missed. Make sure you have enough space on medium!\n         " + npe.getMessage(), EMsgType.FAIL);
            npe.printStackTrace();
        }
        catch (Exception e) {
            this.print(e.getMessage(), EMsgType.FAIL);
            e.printStackTrace();
        }
    }

    private boolean isInvalidReply(byte[] reply) {
        return !MAGIC.equals(new String(reply, 0, 4, StandardCharsets.UTF_8));
    }

    private void fileRangeCmd() throws Exception {
        byte[] readData = this.readUsb();
        byte[] sizeAsBytes = Arrays.copyOfRange(readData, 0, 8);
        long size = DataConvertUtils.arrToLongLE(readData, 0);
        long offset = DataConvertUtils.arrToLongLE(readData, 8);
        String fileName = new String(this.readUsb(), StandardCharsets.UTF_8);
        this.print(String.format("Reply to: %s%n         Offset: %-20d 0x%x%n         Size:   %-20d 0x%x", fileName, offset, offset, size, size), EMsgType.INFO);
        File file = (File)this.nspMap.get(fileName);
        boolean isSplitFile = file.isDirectory();
        this.sendFileMetadata(sizeAsBytes);
        if (isSplitFile) {
            this.sendSplitFile(file, size, offset);
        } else {
            this.sendNormalFile(file, size, offset);
        }
    }

    private void sendSplitFile(File file, long size, long offset) throws Exception {
        try (NSSplitReader inStream = new NSSplitReader(file, size);){
            if (inStream.seek(offset) != offset) {
                throw new IOException("Requested offset is out of file size. Nothing to transmit.");
            }
            this.sendFile(size, inStream);
        }
        this.logPrinter.updateProgress(1.0);
    }

    private void sendNormalFile(File file, long size, long offset) throws Exception {
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));){
            if (inStream.skip(offset) != offset) {
                throw new IOException("Requested offset is out of file size. Nothing to transmit.");
            }
            this.sendFile(size, inStream);
        }
        this.logPrinter.updateProgress(1.0);
    }

    private void sendFile(long size, InputStream inStream) throws Exception {
        long currentOffset = 0L;
        int chunk = 0x800000;
        while (currentOffset < size) {
            byte[] readBuffer;
            if (currentOffset + (long)chunk >= size) {
                chunk = Math.toIntExact(size - currentOffset);
            }
            if (inStream.read(readBuffer = new byte[chunk]) != chunk) {
                throw new IOException("Reading from stream suddenly ended");
            }
            this.writeUsb(readBuffer, "Failure during file transfer");
            this.logPrinter.updateProgress((double)(currentOffset += (long)chunk) / (double)size);
        }
    }

    private void sendFileMetadata(byte[] sizeAsBytes) throws Exception {
        this.writeUsb(STANDARD_REPLY, "Sending response [1/3]");
        this.writeUsb(sizeAsBytes, "Sending response [2/3]");
        this.writeUsb(TWELVE_ZERO_BYTES, "Sending response [3/3]");
    }

    private void writeUsb(byte[] message, String operation) throws Exception {
        IntBuffer wBufferTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)1, ByteBuffer.allocateDirect(message.length).put(message), wBufferTransferred, 5050L);
            switch (result) {
                case 0: {
                    if (wBufferTransferred.get() == message.length) {
                        return;
                    }
                    this.print(operation + "\n         Data transfer issue [write]\n         Requested: " + message.length + "\n         Transferred: " + wBufferTransferred.get(), EMsgType.FAIL);
                    throw new LibUsbException("Transferred amount of data mismatch", 0);
                }
                case -7: {
                    continue block4;
                }
            }
            this.print(operation + "\n         Data transfer issue [write]\n         Returned: " + LibUsb.errorName(result) + "\n         (execution stopped)", EMsgType.FAIL);
            throw new LibUsbException(result);
        }
        throw new InterruptedException("Execution interrupted");
    }

    private byte[] readUsb() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(512);
        IntBuffer rBufferTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, rBufferTransferred, 1000L);
            switch (result) {
                case 0: {
                    byte[] receivedBytes = new byte[rBufferTransferred.get()];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            throw new Exception("Data transfer issue [read]\n         Returned: " + LibUsb.errorName(result) + "\n         (execution stopped)");
        }
        throw new InterruptedException("Execution interrupted");
    }
}

