/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.MediaFeatures;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.expression.ConjunctionExpression;
import com.sun.javafx.css.media.expression.ConstantExpression;
import com.sun.javafx.css.media.expression.DisjunctionExpression;
import com.sun.javafx.css.media.expression.NegationExpression;
import com.sun.javafx.css.parser.Token;
import com.sun.javafx.css.parser.TokenStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public final class MediaQueryParser {
    private static final Predicate<Token> IDENT = token -> token.getType() == 11;
    private static final Predicate<Token> LPAREN = token -> token.getType() == 34;
    private static final Predicate<Token> RPAREN = token -> token.getType() == 35;
    private static final Predicate<Token> COLON = token -> token.getType() == 31;
    private static final Predicate<Token> NOT_COMMA = token -> token.getType() != 36;
    private static final Predicate<Token> NOT_KEYWORD = token -> MediaQueryParser.equalsIdentIgnoreCase(token, "not");
    private static final Predicate<Token> AND_KEYWORD = token -> MediaQueryParser.equalsIdentIgnoreCase(token, "and");
    private static final Predicate<Token> OR_KEYWORD = token -> MediaQueryParser.equalsIdentIgnoreCase(token, "or");
    private final BiConsumer<Token, String> errorHandler;

    public MediaQueryParser(BiConsumer<Token, String> biConsumer) {
        this.errorHandler = Objects.requireNonNull(biConsumer);
    }

    public List<MediaQuery> parseMediaQueryList(List<Token> list) {
        TokenStream tokenStream = new TokenStream(list);
        ArrayList<MediaQuery> arrayList = new ArrayList<MediaQuery>();
        boolean bl = false;
        block4: while (tokenStream.consume() != null) {
            switch (tokenStream.current().getType()) {
                case 36: {
                    if (bl || arrayList.isEmpty()) {
                        this.errorHandler.accept(tokenStream.current(), "Unexpected token");
                    }
                    bl = true;
                    continue block4;
                }
                case 11: 
                case 34: {
                    bl = false;
                    tokenStream.reconsume();
                    MediaQuery mediaQuery = this.parseMediaCondition(tokenStream);
                    if (mediaQuery != null) {
                        arrayList.add(mediaQuery);
                        continue block4;
                    }
                    while (tokenStream.consumeIf(NOT_COMMA) != null) {
                    }
                    arrayList.add(new ConstantExpression(false));
                    continue block4;
                }
            }
            this.errorHandler.accept(tokenStream.current(), "Unexpected token");
            return arrayList;
        }
        return arrayList;
    }

    private MediaQuery parseMediaCondition(TokenStream tokenStream) {
        if (tokenStream.consumeIf(NOT_KEYWORD) != null) {
            MediaQuery mediaQuery = this.parseMediaInParens(tokenStream);
            return mediaQuery != null ? new NegationExpression(mediaQuery) : null;
        }
        ArrayList<MediaQuery> arrayList = new ArrayList<MediaQuery>();
        MediaQuery mediaQuery = this.parseMediaInParens(tokenStream);
        if (mediaQuery == null) {
            return null;
        }
        arrayList.add(mediaQuery);
        if (!this.parseRepeatingMediaCondition(tokenStream, arrayList, AND_KEYWORD, OR_KEYWORD)) {
            return null;
        }
        if (arrayList.size() >= 2) {
            return ConjunctionExpression.of(arrayList);
        }
        if (!this.parseRepeatingMediaCondition(tokenStream, arrayList, OR_KEYWORD, AND_KEYWORD)) {
            return null;
        }
        if (arrayList.size() >= 2) {
            return DisjunctionExpression.of(arrayList);
        }
        return (MediaQuery)arrayList.getFirst();
    }

    private boolean parseRepeatingMediaCondition(TokenStream tokenStream, List<MediaQuery> list, Predicate<Token> predicate, Predicate<Token> predicate2) {
        Object object;
        while (tokenStream.consumeIf(predicate) != null) {
            object = this.parseMediaInParens(tokenStream);
            if (object == null) {
                return false;
            }
            list.add((MediaQuery)object);
        }
        if (list.size() >= 2 && (object = tokenStream.peek()) != null && predicate2.test((Token)object)) {
            this.errorHandler.accept(tokenStream.consume(), "Unexpected token");
            return false;
        }
        return true;
    }

    private MediaQuery parseMediaInParens(TokenStream tokenStream) {
        if (tokenStream.matches(LPAREN, IDENT, RPAREN) || tokenStream.matches(LPAREN, IDENT, COLON)) {
            return this.parseMediaFeature(tokenStream);
        }
        if (tokenStream.consumeIf(LPAREN) != null) {
            MediaQuery mediaQuery = this.parseMediaCondition(tokenStream);
            if (tokenStream.consumeIf(RPAREN) == null) {
                this.errorHandler.accept(tokenStream.consume(), "Expected RPAREN");
                return null;
            }
            return mediaQuery;
        }
        this.errorHandler.accept(tokenStream.consume(), "Expected LPAREN");
        return null;
    }

    private MediaQuery parseMediaFeature(TokenStream tokenStream) {
        if (tokenStream.consumeIf(LPAREN) == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected LPAREN");
            return null;
        }
        Token token = tokenStream.consumeIf(IDENT);
        if (token == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected IDENT");
            return null;
        }
        Token token2 = null;
        if (tokenStream.consumeIf(COLON) != null && (token2 = tokenStream.consume()) == null) {
            while (tokenStream.peek() != null) {
                tokenStream.consume();
            }
            this.errorHandler.accept(tokenStream.current(), "Expected token");
            return null;
        }
        if (tokenStream.consumeIf(RPAREN) == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected RPAREN");
            return null;
        }
        try {
            return MediaFeatures.featureQueryExpression(token.getText(), token2 != null ? token2.getText() : null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.errorHandler.accept(token2, illegalArgumentException.getMessage());
            return null;
        }
    }

    private static boolean equalsIdentIgnoreCase(Token token, String string) {
        return token.getType() == 11 && string.equalsIgnoreCase(token.getText());
    }
}

