/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.aesctr;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import libKonogonka.aesctr.AesCtrDecrypt;

public class AesCtrDecryptForMediaBlocks
extends AesCtrDecrypt {
    private final SecretKeySpec key;
    private final byte[] ivArray;
    private Cipher cipher;
    private final long initialOffset;

    public AesCtrDecryptForMediaBlocks(byte[] key, byte[] sectionCTR, long realMediaOffset) throws Exception {
        this.key = new SecretKeySpec(key, "AES");
        this.ivArray = Arrays.copyOf(sectionCTR, 16);
        this.initialOffset = realMediaOffset;
        this.reset();
    }

    @Override
    public byte[] decryptNext(byte[] encryptedBlock) {
        return this.cipher.update(encryptedBlock);
    }

    @Override
    public void resetAndSkip(long blockCount) throws Exception {
        this.cipher = Cipher.getInstance("AES/CTR/NoPadding", "BC");
        long mediaOffset = this.initialOffset + blockCount * 512L;
        this.cipher.init(2, (Key)this.key, this.getIv(mediaOffset));
    }

    private IvParameterSpec getIv(long mediaOffset) {
        byte[] iv = (byte[])this.ivArray.clone();
        long offset = mediaOffset >> 4;
        for (int i = 0; i < 8; ++i) {
            iv[16 - i - 1] = (byte)(offset & 0xFFL);
            offset >>= 8;
        }
        return new IvParameterSpec(iv);
    }

    @Override
    public void reset() throws Exception {
        this.resetAndSkip(0L);
    }
}

