/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.ModelControllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.AnimationTimer;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import nsusbloader.Controllers.Payload;
import nsusbloader.MediatorControl;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EModule;

public class MessagesConsumer
extends AnimationTimer {
    private static final MediatorControl mediator = MediatorControl.INSTANCE;
    private static final TextArea logsArea = mediator.getLogArea();
    private static final ProgressBar progressBar = mediator.getProgressBar();
    private static final ResourceBundle resourceBundle = mediator.getResourceBundle();
    private final BlockingQueue<String> msgQueue;
    private final BlockingQueue<Double> progressQueue;
    private final HashMap<String, EFileStatus> statusMap;
    private final EModule appModuleType;
    private final AtomicBoolean oneLinerStatus;
    private boolean isInterrupted;

    MessagesConsumer(EModule appModuleType, BlockingQueue<String> msgQueue, BlockingQueue<Double> progressQueue, HashMap<String, EFileStatus> statusMap, AtomicBoolean oneLinerStatus) {
        this.appModuleType = appModuleType;
        this.isInterrupted = false;
        this.msgQueue = msgQueue;
        this.progressQueue = progressQueue;
        this.statusMap = statusMap;
        this.oneLinerStatus = oneLinerStatus;
        progressBar.setProgress(0.0);
        progressBar.setProgress(-1.0);
        logsArea.clear();
        mediator.setTransferActive(appModuleType, true, new Payload());
    }

    @Override
    public void handle(long l) {
        ArrayList<Double> progress;
        int progressReceived;
        ArrayList<String> messages = new ArrayList<String>();
        int msgReceived = this.msgQueue.drainTo(messages);
        if (msgReceived > 0) {
            messages.forEach(logsArea::appendText);
        }
        if ((progressReceived = this.progressQueue.drainTo(progress = new ArrayList<Double>())) > 0) {
            progress.forEach(prg -> {
                if (prg != 1.0) {
                    progressBar.setProgress((double)prg);
                } else {
                    progressBar.setProgress(-1.0);
                }
            });
        }
        if (this.isInterrupted) {
            this.updateElementsAndStop();
        }
    }

    private void updateElementsAndStop() {
        Payload payload = new Payload(resourceBundle.getString(this.oneLinerStatus.get() ? "done_txt" : "failure_txt"), this.statusMap);
        mediator.setTransferActive(this.appModuleType, false, payload);
        progressBar.setProgress(0.0);
        this.stop();
    }

    public void interrupt() {
        this.isInterrupted = true;
    }
}

