/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.usb.GoldLeaf_05;
import nsusbloader.com.usb.GoldLeaf_07;
import nsusbloader.com.usb.GoldLeaf_08;
import nsusbloader.com.usb.TinFoil;
import nsusbloader.com.usb.TransferModule;
import nsusbloader.com.usb.UsbConnect;
import nsusbloader.com.usb.gl.GoldLeaf_010;
import nsusbloader.com.usb.gl.GoldLeaf_111;
import org.usb4java.DeviceHandle;

public class UsbCommunications
extends CancellableRunnable {
    private final ILogPrinter logPrinter;
    private final LinkedHashMap<String, File> nspMap;
    private final String protocol;
    private final boolean nspFilterForGl;

    public UsbCommunications(List<File> nspList, String protocol, boolean filterNspFilesOnlyForGl) {
        this.protocol = protocol;
        this.nspFilterForGl = filterNspFilesOnlyForGl;
        this.nspMap = new LinkedHashMap();
        for (File f : nspList) {
            this.nspMap.put(f.getName(), f);
        }
        this.logPrinter = Log.getPrinter(EModule.USB_NET_TRANSFERS);
    }

    @Override
    public void run() {
        this.print("\tStart");
        UsbConnect usbConnect = UsbConnect.connectHomebrewMode(this.logPrinter);
        if (!usbConnect.isConnected()) {
            this.close(EFileStatus.FAILED);
            return;
        }
        DeviceHandle handler = usbConnect.getNsHandler();
        TransferModule module = switch (this.protocol) {
            case "TinFoil" -> new TinFoil(handler, this.nspMap, this, this.logPrinter);
            case "GoldLeaf v1.1.1" -> new GoldLeaf_111(handler, this.nspMap, this, this.logPrinter, this.nspFilterForGl);
            case "GoldLeaf v0.10-1.0.0" -> new GoldLeaf_010(handler, this.nspMap, this, this.logPrinter, this.nspFilterForGl);
            case "GoldLeaf v0.8-0.9" -> new GoldLeaf_08(handler, this.nspMap, this, this.logPrinter, this.nspFilterForGl);
            case "GoldLeaf v0.7.x" -> new GoldLeaf_07(handler, this.nspMap, this, this.logPrinter, this.nspFilterForGl);
            default -> new GoldLeaf_05(handler, this.nspMap, this, this.logPrinter);
        };
        usbConnect.close();
        this.close(module.getStatus());
    }

    private void close(EFileStatus status) {
        this.logPrinter.update(this.nspMap, status);
        this.print("\tEnd");
        this.logPrinter.close();
    }

    private void print(String message) {
        try {
            this.logPrinter.print(message, EMsgType.INFO);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

