/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NCA.NCASectionTableBlock;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BucketTreeHeader {
    private static final Logger log = LogManager.getLogger(BucketTreeHeader.class);
    private final String magic;
    private final int version;
    private final int entryCount;
    private final byte[] unknown;

    BucketTreeHeader(byte[] rawBytes) {
        this.magic = new String(Arrays.copyOfRange(rawBytes, 0, 4), StandardCharsets.US_ASCII);
        this.version = Converter.getLEint(rawBytes, 4);
        this.entryCount = Converter.getLEint(rawBytes, 8);
        this.unknown = Arrays.copyOfRange(rawBytes, 12, 16);
    }

    public String getMagic() {
        return this.magic;
    }

    public int getVersion() {
        return this.version;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public byte[] getUnknown() {
        return this.unknown;
    }

    public void printDebug() {
        log.debug("BucketTreeHeader\nMagic       : " + this.magic + "\nVersion     : " + this.version + "\nEntryCount  :" + this.entryCount + "\nUnknown     :" + Converter.byteArrToHexStringAsLE(this.unknown) + "\n");
    }
}

