/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2.ini1;

import java.nio.ByteBuffer;
import libKonogonka.fs.other.System2.ini1.KIP1Header;

public class KIP1Raw {
    private KIP1Header headerObject;
    private final byte[] header;
    private final byte[] _textDecompressedSection;
    private final byte[] _roDataDecompressedSection;
    private final byte[] _rwDataDecompressedSection;

    KIP1Raw(byte[] header, byte[] _textDecompressedSection, byte[] _roDataDecompressedSection, byte[] _rwDataDecompressedSection) {
        this.header = header;
        this._textDecompressedSection = _textDecompressedSection;
        this._roDataDecompressedSection = _roDataDecompressedSection;
        this._rwDataDecompressedSection = _rwDataDecompressedSection;
        try {
            this.headerObject = new KIP1Header(header);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public KIP1Header getHeader() {
        return this.headerObject;
    }

    public byte[] getHeaderRaw() {
        return this.header;
    }

    public byte[] getTextRaw() {
        return this._textDecompressedSection;
    }

    public byte[] getRoDataRaw() {
        return this._roDataDecompressedSection;
    }

    public byte[] getRwDataRaw() {
        return this._rwDataDecompressedSection;
    }

    public byte[] getRaw() {
        ByteBuffer entireKip1 = ByteBuffer.allocate(this.header.length + this._textDecompressedSection.length + this._roDataDecompressedSection.length + this._rwDataDecompressedSection.length);
        entireKip1.put(this.header).put(this._textDecompressedSection).put(this._roDataDecompressedSection).put(this._rwDataDecompressedSection);
        return entireKip1.array();
    }
}

