/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.RomFs.view;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileMetaTablePlainView {
    private static final Logger log = LogManager.getLogger(FileMetaTablePlainView.class);

    public FileMetaTablePlainView(long fileMetadataTableLength, byte[] fileMetadataTable) {
        int i = 0;
        while ((long)i < fileMetadataTableLength) {
            FileMeta fileMeta = new FileMeta();
            fileMeta.containingDirectoryOffset = Converter.getLEint(fileMetadataTable, i);
            fileMeta.nextSiblingFileOffset = Converter.getLEint(fileMetadataTable, i += 4);
            fileMeta.fileDataOffset = Converter.getLElong(fileMetadataTable, i += 4);
            fileMeta.fileDataLength = Converter.getLElong(fileMetadataTable, i += 8);
            fileMeta.nextFileOffset = Converter.getLEint(fileMetadataTable, i += 8);
            fileMeta.fileNameLength = Converter.getLEint(fileMetadataTable, i += 4);
            fileMeta.fileName = new String(Arrays.copyOfRange(fileMetadataTable, i += 4, i + fileMeta.fileNameLength), StandardCharsets.UTF_8);
            i += this.getRealNameSize(fileMeta.fileNameLength);
            log.debug("- FILE -\nOffset of Containing Directory                    " + RainbowDump.formatDecHexString(fileMeta.containingDirectoryOffset) + "\nOffset of next Sibling File                       " + RainbowDump.formatDecHexString(fileMeta.nextSiblingFileOffset) + "\nOffset of File's Data                             " + RainbowDump.formatDecHexString(fileMeta.fileDataOffset) + "\nLength of File's Data                             " + RainbowDump.formatDecHexString(fileMeta.fileDataLength) + "\nOffset of next File in the same Hash Table bucket " + RainbowDump.formatDecHexString(fileMeta.nextFileOffset) + "\nName Length                                       " + RainbowDump.formatDecHexString(fileMeta.fileNameLength) + "\nName Length (rounded up to multiple of 4)         " + fileMeta.fileName + "\n");
        }
    }

    private int getRealNameSize(int value) {
        if (value % 4 == 0) {
            return value;
        }
        return value + 4 - value % 4;
    }

    private static class FileMeta {
        int containingDirectoryOffset;
        int nextSiblingFileOffset;
        long fileDataOffset;
        long fileDataLength;
        int nextFileOffset;
        int fileNameLength;
        String fileName;

        private FileMeta() {
        }
    }
}

