/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches.loader;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.Utilities.patches.MalformedIniFileException;

public class LoaderIniMaker {
    private static final String FILE_HEADER_TEXT = "# UTF-8\n# A KIP section is [kip1_name:sha256_hex_8bytes]\n# A patchset is .patch_name=kip_section_dec:offset_hex_0x:length_hex_0x:src_data_hex,dst_data_hex\n# _dec: 1 char decimal | _hex_0x: max u32 prefixed with 0x | _hex: hex array.\n# Kip1 section decimals: TEXT: 0, RODATA: 1, DATA: 2.\n";
    private final ILogPrinter logPrinter;
    private final String saveToLocation;
    private final int offset;
    private String sectionDeclaration;
    private String patchSet;

    LoaderIniMaker(ILogPrinter logPrinter, String saveToLocation, int foundOffset, String patchName) throws Exception {
        this.logPrinter = logPrinter;
        this.saveToLocation = saveToLocation;
        this.offset = foundOffset + 6;
        this.mkDirs();
        this.makeSectionDeclaration(patchName);
        this.makePatchSet1();
        this.writeFile();
    }

    private void mkDirs() {
        File parentFolder = new File(this.saveToLocation + File.separator + "bootloader");
        parentFolder.mkdirs();
    }

    private void makeSectionDeclaration(String patchName) {
        this.sectionDeclaration = "[Loader:" + patchName.substring(0, 16) + "]";
    }

    private void makePatchSet1() {
        this.patchSet = String.format(".nosigchk=0:0x%02X:0x1:01,00", this.offset);
    }

    private void writeFile() throws Exception {
        String iniLocation = this.saveToLocation + File.separator + "bootloader" + File.separator + "patches.ini";
        Path iniLocationPath = Paths.get(iniLocation, new String[0]);
        boolean iniNotExists = Files.notExists(iniLocationPath, new LinkOption[0]);
        try (RandomAccessFile ini = new RandomAccessFile(iniLocation, "rw");){
            if (iniNotExists) {
                ini.writeBytes(FILE_HEADER_TEXT);
            } else {
                String line;
                while ((line = ini.readLine()) != null) {
                    if (!line.startsWith(this.sectionDeclaration)) continue;
                    String expression = ini.readLine();
                    if (expression == null || !expression.startsWith(this.patchSet)) {
                        throw new MalformedIniFileException("Somewhere near " + ini.getFilePointer());
                    }
                    return;
                }
            }
            ini.writeBytes("\n#Loader (Atmosphere)\n");
            ini.writeBytes(this.sectionDeclaration);
            ini.writeBytes("\n");
            ini.writeBytes(this.patchSet);
            ini.writeBytes("\n");
        }
        catch (MalformedIniFileException e) {
            e.printStackTrace();
            this.logPrinter.print("Existing patches.ini file is malformed or contains incorrect (outdated) information regarding current patch.\nIt's now saved at " + iniLocation + ".OLD\nNew patches.ini file created instead.", EMsgType.WARNING);
            Files.move(iniLocationPath, Paths.get(iniLocation + ".OLD", new String[0]), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            this.writeFile();
        }
    }
}

