/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.blz;

import libKonogonka.Converter;

public class BlzDecompress {
    public static final byte BLZ_MASK = -128;

    public int decompress(byte[] compressed, byte[] decompressed) throws Exception {
        int finalOffset;
        int additionalLength = Converter.getLEint(compressed, compressed.length - 4);
        int headerSize = Converter.getLEint(compressed, compressed.length - 8);
        int compressedAndHeaderSize = Converter.getLEint(compressed, compressed.length - 12);
        if (additionalLength == 0) {
            throw new Exception("File not compressed");
        }
        if (additionalLength < 0) {
            throw new Exception("File not supported. Please file a bug " + additionalLength);
        }
        int delta = compressed.length - compressedAndHeaderSize;
        int compressedOffset = compressedAndHeaderSize - headerSize + delta;
        int resultingSize = finalOffset = compressedAndHeaderSize + additionalLength + delta;
        block0: while (true) {
            byte control = compressed[--compressedOffset];
            int i = 0;
            while (true) {
                if (i >= 8) continue block0;
                if ((control & 0xFFFFFF80) == 0) {
                    if (compressedOffset < 1) {
                        throw new Exception("BLZ decompression is out of range");
                    }
                    decompressed[--finalOffset] = compressed[--compressedOffset];
                } else {
                    if (compressedOffset < 2) {
                        throw new Exception("BLZ decompression is out of range");
                    }
                    short segmentValue = (short)(compressed[(compressedOffset -= 2) + 1] << 8 | compressed[compressedOffset] & 0xFF);
                    int segmentSize = (segmentValue >> 12 & 0xF) + 3;
                    int segmentPosition = (segmentValue & 0xFFF) + 3;
                    if (segmentSize > finalOffset) {
                        segmentSize = finalOffset;
                    }
                    finalOffset -= segmentSize;
                    for (int j = 0; j < segmentSize; ++j) {
                        decompressed[finalOffset + j] = decompressed[finalOffset + j + segmentPosition];
                    }
                }
                control = (byte)(control << 1);
                if (finalOffset == delta) break block0;
                ++i;
            }
            break;
        }
        if (delta != 0) {
            System.arraycopy(compressed, 0, decompressed, 0, delta);
        }
        return resultingSize;
    }
}

