/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.other.System2.ini1;

import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.RainbowDump;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Ini1Header {
    private static final Logger log = LogManager.getLogger(Ini1Header.class);
    private final String magic;
    private final int size;
    private final int kipNumber;
    private final byte[] reserved;

    public Ini1Header(byte[] headerBytes) {
        this.magic = new String(headerBytes, 0, 4);
        this.size = Converter.getLEint(headerBytes, 4);
        this.kipNumber = Converter.getLEint(headerBytes, 8);
        this.reserved = Arrays.copyOfRange(headerBytes, 12, 16);
    }

    public String getMagic() {
        return this.magic;
    }

    public int getSize() {
        return this.size;
    }

    public int getKipNumber() {
        return this.kipNumber;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public void printDebug() {
        log.debug("..:: INI1 Header ::..\nMagic         : " + this.magic + "\nSize          : " + RainbowDump.formatDecHexString(this.size) + "\nKPIs number   : " + RainbowDump.formatDecHexString(this.kipNumber) + "\nReserved      : " + Converter.byteArrToHexStringAsLE(this.reserved));
    }
}

