/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.concurrent.Task;
import nsusbloader.MediatorControl;

public class FilesDropHandleTask
extends Task<List<File>> {
    private final String filesRegex;
    private final String foldersRegex;
    private final List<File> filesDropped;
    private final List<File> allFiles;
    private final String messageTemplate;
    private long filesScanned = 0L;
    private long filesAdded = 0L;

    FilesDropHandleTask(List<File> files, String filesRegex, String foldersRegex) {
        this.filesDropped = files;
        this.filesRegex = filesRegex;
        this.foldersRegex = foldersRegex;
        this.allFiles = new ArrayList<File>();
        this.messageTemplate = MediatorControl.INSTANCE.getResourceBundle().getString("windowBodyFilesScanned");
    }

    @Override
    protected List<File> call() {
        if (this.filesDropped == null || this.filesDropped.isEmpty()) {
            return this.allFiles;
        }
        for (File file : this.filesDropped) {
            if (this.isCancelled()) {
                return new ArrayList<File>();
            }
            this.collectFiles(file);
            this.updateMessage(String.format(this.messageTemplate, this.filesScanned++, this.filesAdded));
        }
        return this.allFiles;
    }

    private void collectFiles(File startFolder) {
        if (startFolder == null) {
            return;
        }
        String startFolderNameInLowercase = startFolder.getName().toLowerCase();
        if (startFolder.isFile()) {
            if (startFolderNameInLowercase.matches(this.filesRegex)) {
                this.allFiles.add(startFolder);
                ++this.filesAdded;
            }
            return;
        }
        if (startFolderNameInLowercase.matches(this.foldersRegex)) {
            this.allFiles.add(startFolder);
            ++this.filesAdded;
            return;
        }
        File[] files = startFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (this.isCancelled()) {
                return;
            }
            this.collectFiles(file);
            this.updateMessage(String.format(this.messageTemplate, this.filesScanned++, this.filesAdded));
        }
    }
}

