/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.XCI;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.ExportAble;
import libKonogonka.fs.ISuperProvider;
import libKonogonka.fs.XCI.HFS0File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HFS0Provider
extends ExportAble
implements ISuperProvider {
    private static final Logger log = LogManager.getLogger(HFS0Provider.class);
    private final String magic;
    private final int filesCount;
    private final byte[] padding;
    private final int stringTableSize;
    private final long rawFileDataStart;
    private final HFS0File[] hfs0Files;
    private final File file;

    HFS0Provider(long hfsOffsetPosition, RandomAccessFile raf, File file) throws Exception {
        this.file = file;
        byte[] hfs0bytes = new byte[16];
        raf.seek(hfsOffsetPosition);
        if (raf.read(hfs0bytes) != 16) {
            throw new Exception("Read HFS0 structure failure. Can't read first 16 bytes on requested offset.");
        }
        this.magic = new String(hfs0bytes, 0, 4, StandardCharsets.US_ASCII);
        this.filesCount = Converter.getLEint(hfs0bytes, 4);
        this.stringTableSize = Converter.getLEint(hfs0bytes, 8);
        this.padding = Arrays.copyOfRange(hfs0bytes, 12, 16);
        this.hfs0Files = new HFS0File[this.filesCount];
        long[] offsetSubFile = new long[this.filesCount];
        long[] sizeSubFile = new long[this.filesCount];
        int[] hashedRegionSubFile = new int[this.filesCount];
        boolean[] paddingSubFile = new boolean[this.filesCount];
        byte[][] SHA256HashSubFile = new byte[this.filesCount][];
        int[] stringTableOffsetSubFile = new int[this.filesCount];
        try {
            int i;
            byte[] metaInfoBytes = new byte[64];
            for (int i2 = 0; i2 < this.filesCount; ++i2) {
                if (raf.read(metaInfoBytes) != 64) {
                    throw new Exception("Read HFS0 File Entry Table failure for file # " + i2);
                }
                offsetSubFile[i2] = Converter.getLElong(metaInfoBytes, 0);
                sizeSubFile[i2] = Converter.getLElong(metaInfoBytes, 8);
                hashedRegionSubFile[i2] = Converter.getLEint(metaInfoBytes, 20);
                paddingSubFile[i2] = Arrays.equals(Arrays.copyOfRange(metaInfoBytes, 24, 32), new byte[8]);
                SHA256HashSubFile[i2] = Arrays.copyOfRange(metaInfoBytes, 32, 64);
                stringTableOffsetSubFile[i2] = Converter.getLEint(metaInfoBytes, 16);
            }
            this.rawFileDataStart = raf.getFilePointer() + (long)this.stringTableSize;
            if (this.stringTableSize <= 0) {
                throw new Exception("String table size of HFS0 less or equal to zero");
            }
            byte[] stringTbl = new byte[this.stringTableSize];
            if (raf.read(stringTbl) != this.stringTableSize) {
                throw new Exception("Read HFS0 String table failure. Can't read requested string table size (" + this.stringTableSize + ")");
            }
            String[] namesSubFile = new String[this.filesCount];
            for (i = 0; i < this.filesCount; ++i) {
                int j = 0;
                while (stringTbl[stringTableOffsetSubFile[i] + j] != 0) {
                    ++j;
                }
                namesSubFile[i] = new String(stringTbl, stringTableOffsetSubFile[i], j, StandardCharsets.UTF_8);
            }
            for (i = 0; i < this.filesCount; ++i) {
                this.hfs0Files[i] = new HFS0File(namesSubFile[i], offsetSubFile[i], sizeSubFile[i], hashedRegionSubFile[i], paddingSubFile[i], SHA256HashSubFile[i]);
            }
        }
        catch (IOException ioe) {
            throw new Exception("Read HFS0 structure failure: " + ioe.getMessage());
        }
    }

    public String getMagic() {
        return this.magic;
    }

    public int getFilesCount() {
        return this.filesCount;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public int getStringTableSize() {
        return this.stringTableSize;
    }

    @Override
    public long getRawFileDataStart() {
        return this.rawFileDataStart;
    }

    public HFS0File[] getHfs0Files() {
        return this.hfs0Files;
    }

    @Override
    public boolean exportContent(String saveToLocation, String subFileName) throws Exception {
        for (int i = 0; i < this.hfs0Files.length; ++i) {
            if (!this.hfs0Files[i].getName().equals(subFileName)) continue;
            return this.exportContent(saveToLocation, i);
        }
        throw new FileNotFoundException("No file with such name exists: " + subFileName);
    }

    @Override
    public boolean exportContent(String saveToLocation, int subFileNumber) throws Exception {
        HFS0File subFile = this.hfs0Files[subFileNumber];
        this.stream = this.getStreamProducer(subFileNumber).produce();
        return this.export(saveToLocation, subFile.getName(), 0L, subFile.getSize());
    }

    @Override
    public InFileStreamProducer getStreamProducer(String subFileName) throws FileNotFoundException {
        for (int i = 0; i < this.hfs0Files.length; ++i) {
            if (!this.hfs0Files[i].getName().equals(subFileName)) continue;
            return this.getStreamProducer(i);
        }
        throw new FileNotFoundException("No file with such name exists: " + subFileName);
    }

    @Override
    public InFileStreamProducer getStreamProducer(int subFileNumber) {
        long offset = this.rawFileDataStart + this.hfs0Files[subFileNumber].getOffset();
        return new InFileStreamProducer(this.file, offset);
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

