/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Controllers;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.stage.DirectoryChooser;
import nsusbloader.AppPreferences;
import nsusbloader.Controllers.ISubscriber;
import nsusbloader.Controllers.Payload;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.Utilities.nxdumptool.NxdtTask;

public class NxdtController
implements Initializable,
ISubscriber {
    @FXML
    private Label saveToLocationLbl;
    @FXML
    private Label statusLbl;
    @FXML
    private Button injectPldBtn;
    private ResourceBundle rb;
    private Region btnDumpStopImage;
    private Thread workThread;
    private CancellableRunnable nxdtTask;

    @Override
    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.rb = resourceBundle;
        String saveToLocation = AppPreferences.getInstance().getNXDTSaveToLocation();
        this.saveToLocationLbl.setText(saveToLocation);
        this.btnDumpStopImage = new Region();
        this.btnDumpStopImage.getStyleClass().add("regionDump");
        this.injectPldBtn.getStyleClass().add("buttonUp");
        this.injectPldBtn.setGraphic(this.btnDumpStopImage);
        this.injectPldBtn.setOnAction(event -> this.startDumpProcess());
    }

    @FXML
    private void bntSelectSaveTo() {
        DirectoryChooser dc = new DirectoryChooser();
        dc.setTitle(this.rb.getString("tabSplMrg_Btn_SelectFolder"));
        dc.setInitialDirectory(new File(this.saveToLocationLbl.getText()));
        File saveToDir = dc.showDialog(this.saveToLocationLbl.getScene().getWindow());
        if (saveToDir != null) {
            this.saveToLocationLbl.setText(saveToDir.getAbsolutePath());
        }
    }

    private void startDumpProcess() {
        if (this.workThread == null || !this.workThread.isAlive()) {
            this.nxdtTask = new NxdtTask(this.saveToLocationLbl.getText());
            this.workThread = new Thread(this.nxdtTask);
            this.workThread.setDaemon(true);
            this.workThread.start();
        }
    }

    private void stopBtnAction() {
        if (this.workThread != null && this.workThread.isAlive()) {
            this.nxdtTask.cancel();
        }
    }

    public void updatePreferencesOnExit() {
        AppPreferences.getInstance().setNXDTSaveToLocation(this.saveToLocationLbl.getText());
    }

    @Override
    public void notify(EModule type, boolean isActive, Payload payload) {
        if (!type.equals((Object)EModule.NXDT)) {
            this.injectPldBtn.setDisable(isActive);
            return;
        }
        this.statusLbl.setText(payload.getMessage());
        if (isActive) {
            this.btnDumpStopImage.getStyleClass().clear();
            this.btnDumpStopImage.getStyleClass().add("regionStop");
            this.injectPldBtn.setOnAction(e -> this.stopBtnAction());
            this.injectPldBtn.setText(this.rb.getString("btn_Stop"));
            this.injectPldBtn.getStyleClass().remove("buttonUp");
            this.injectPldBtn.getStyleClass().add("buttonStop");
            return;
        }
        this.btnDumpStopImage.getStyleClass().clear();
        this.btnDumpStopImage.getStyleClass().add("regionDump");
        this.injectPldBtn.setOnAction(e -> this.startDumpProcess());
        this.injectPldBtn.setText(this.rb.getString("tabNXDT_Btn_Start"));
        this.injectPldBtn.getStyleClass().remove("buttonStop");
        this.injectPldBtn.getStyleClass().add("buttonUp");
    }
}

