/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.Utilities.patches;

import libKonogonka.Converter;
import nsusbloader.NSLMain;

public class BinToAsmPrinter {
    private static final String ANSI_RESET;
    private static final String ANSI_RED;
    private static final String ANSI_GREEN;
    private static final String ANSI_BLUE;
    private static final String ANSI_YELLOW;
    private static final String ANSI_PURPLE;
    private static final String ANSI_CYAN;

    public static String print(int instructionExpression, int offset) {
        if (instructionExpression == -721215457) {
            return BinToAsmPrinter.printNOP(instructionExpression);
        }
        if ((instructionExpression & 0x7FE0FFE0) == 704644064) {
            return BinToAsmPrinter.printMOVRegister(instructionExpression);
        }
        switch (instructionExpression >> 23 & 0xFF) {
            case 165: {
                return BinToAsmPrinter.printMOV(instructionExpression);
            }
            case 98: {
                if ((instructionExpression & 0x1F) != 31) break;
                return BinToAsmPrinter.printCMN(instructionExpression);
            }
        }
        switch (instructionExpression >> 24 & 0xFF) {
            case 52: 
            case 180: {
                return BinToAsmPrinter.printCBZ(instructionExpression, offset);
            }
            case 53: 
            case 181: {
                return BinToAsmPrinter.printCBNZ(instructionExpression, offset);
            }
            case 54: 
            case 182: {
                return BinToAsmPrinter.printTBZ(instructionExpression, offset);
            }
            case 84: {
                return BinToAsmPrinter.printBConditional(instructionExpression, offset);
            }
        }
        switch (instructionExpression >> 26 & 0x3F) {
            case 5: {
                return BinToAsmPrinter.printB(instructionExpression, offset);
            }
            case 37: {
                return BinToAsmPrinter.printBL(instructionExpression, offset);
            }
        }
        return BinToAsmPrinter.printUnknown(instructionExpression);
    }

    public static String printSimplified(int instructionExpression, int offset) {
        if (instructionExpression == -721215457) {
            return BinToAsmPrinter.printNOPSimplified(instructionExpression, offset);
        }
        if ((instructionExpression & 0x7FE0FFE0) == 704644064) {
            return BinToAsmPrinter.printMOVRegisterSimplified(instructionExpression, offset);
        }
        switch (instructionExpression >> 22 & 0x2FF) {
            case 741: {
                return BinToAsmPrinter.printLRDImmUnsignSimplified(instructionExpression, offset);
            }
            case 229: {
                return BinToAsmPrinter.printLRDBImmUnsignSimplified(instructionExpression, offset);
            }
        }
        if ((instructionExpression >> 21 & 0x7FF) == 450) {
            return BinToAsmPrinter.printImTooLazy("LDURB", instructionExpression, offset);
        }
        switch (instructionExpression >> 22 & 0x1FF) {
            case 163: 
            case 165: 
            case 167: {
                return BinToAsmPrinter.printImTooLazy("LDP", instructionExpression, offset);
            }
        }
        switch (instructionExpression >> 23 & 0x1FF) {
            case 165: {
                return BinToAsmPrinter.printMOVSimplified(instructionExpression, offset);
            }
            case 34: {
                return BinToAsmPrinter.printImTooLazy("ADD", instructionExpression, offset);
            }
            case 98: {
                if ((instructionExpression & 0x1F) == 31) {
                    return BinToAsmPrinter.printCMNSimplified(instructionExpression, offset);
                }
            }
            case 162: {
                return BinToAsmPrinter.printSUBSimplified(instructionExpression, offset);
            }
            case 226: 
            case 482: {
                return BinToAsmPrinter.printCMPSimplified(instructionExpression, offset);
            }
            case 36: 
            case 292: {
                return BinToAsmPrinter.printANDSimplified(instructionExpression, offset);
            }
        }
        switch (instructionExpression >> 24 & 0xFF) {
            case 52: 
            case 180: {
                return BinToAsmPrinter.printCBZSimplified(instructionExpression, offset);
            }
            case 53: 
            case 181: {
                return BinToAsmPrinter.printCBNZSimplified(instructionExpression, offset);
            }
            case 54: 
            case 182: {
                return BinToAsmPrinter.printTBZSimplified(instructionExpression, offset);
            }
            case 84: {
                return BinToAsmPrinter.printBConditionalSimplified(instructionExpression, offset);
            }
            case 107: 
            case 235: {
                if ((instructionExpression & 0x1F) != 31) break;
                return BinToAsmPrinter.printCMPShiftedRegisterSimplified(instructionExpression, offset);
            }
        }
        switch (instructionExpression >> 26 & 0x3F) {
            case 5: {
                return BinToAsmPrinter.printBSimplified(instructionExpression, offset);
            }
            case 37: {
                return BinToAsmPrinter.printBLSimplified(instructionExpression, offset);
            }
        }
        if ((instructionExpression >> 10 & 0x3FFFFF) == 3512256 && (instructionExpression & 0x1F) == 0) {
            return BinToAsmPrinter.printRetSimplified(instructionExpression, offset);
        }
        return BinToAsmPrinter.printUnknownSimplified(instructionExpression, offset);
    }

    private static String printCBZ(int instructionExpression, int offset) {
        int conditionalJumpLocation = (instructionExpression >> 5 & 0x7FFFF) * 4 + offset & 0xFFFFF;
        return String.format(ANSI_YELLOW + "sf == 0 ? <Wt> else <Xt>\nCBZ <?t>, <label>          |.....CBZ signature......|\n" + ANSI_CYAN + "                            sf 0  1  1    0  1  0  0   |imm19..........................................................||Rd.............|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n\n" + ANSI_YELLOW + "CBZ " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), instructionExpression >> 31 == 0 ? "w" : "x", instructionExpression & 0x1F, conditionalJumpLocation, conditionalJumpLocation + 256);
    }

    private static String printCBNZ(int instructionExpression, int offset) {
        int conditionalJumpLocation = (instructionExpression >> 5 & 0x7FFFF) * 4 + offset & 0xFFFFF;
        return String.format(ANSI_YELLOW + "sf == 0 ? <Wt> else <Xt>\nCBNZ <?t>, <label>         |.....CBZ signature......|\n" + ANSI_CYAN + "                            sf 0  1  1    0  1  0     |imm19..........................................................||Rd.............|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n\n" + ANSI_YELLOW + "CBNZ " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), instructionExpression >> 31 == 0 ? "w" : "x", instructionExpression & 0x1F, conditionalJumpLocation, conditionalJumpLocation + 256);
    }

    private static String printCMN(int instructionExpression) {
        int Rn = instructionExpression >> 5 & 0x1F;
        int imm = instructionExpression >> 10 & 0xFFF;
        return String.format(ANSI_YELLOW + "sf == 0 ? <Wt> else <Xt>\nCMN <?n>, <label>           |.....CMN signature...........|                                                            |..CMN signature.|\n" + ANSI_CYAN + "                            sf 0  1  1    0  0  0  1    0 |imm12......................................||Rn.............| 1    1  1  1  1" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n\n" + ANSI_YELLOW + "CMN " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + "\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), instructionExpression >> 31 == 0 ? "w" : "x", Rn, imm);
    }

    private static String printB(int instructionExpression, int offset) {
        int conditionalJumpLocationPatch = (instructionExpression & 0x3FFFFFF) * 4 + offset & 0xFFFFF;
        return String.format(ANSI_YELLOW + "B <label>                  |....B signature...|\n                           " + ANSI_CYAN + " 0  0  0  1    0  1 |imm26...................................................................................|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n" + ANSI_YELLOW + "%s " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), (instructionExpression >> 26 & 0x3F) == 5 ? "B" : "Some weird stuff", conditionalJumpLocationPatch, conditionalJumpLocationPatch + 256);
    }

    private static String printBL(int instructionExpression, int offset) {
        int conditionalJumpLocationPatch = (instructionExpression & 0x3FFFFFF) * 4 + offset & 0xFFFFF;
        return String.format(ANSI_YELLOW + "BL <label>                 |...BL signature...|\n                           " + ANSI_CYAN + " 1  0  0  1    0  1 |imm26...................................................................................|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n" + ANSI_YELLOW + "%s " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), (instructionExpression >> 26 & 0x3F) == 25 ? "BL" : "Some weird stuff", conditionalJumpLocationPatch, conditionalJumpLocationPatch + 256);
    }

    private static String printMOV(int instructionExpression) {
        int imm16 = instructionExpression >> 5 & 0xFFFF;
        int sfHw = instructionExpression >> 22 & 1;
        return String.format(ANSI_YELLOW + "sf == 0 && hw == 0x ? <Wt> else <Xt>\nMOV <?t>, <label>          |.....MOV signature...........|\n" + ANSI_CYAN + "                            sf 1  0  1    0  0  1  0    1 |hw...|imm16.................................................||Rd.............|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n" + ANSI_YELLOW + "MOV " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + "\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), sfHw == 0 ? "w" : "x", instructionExpression & 0x1F, imm16);
    }

    private static String printMOVRegister(int instructionExpression) {
        String sfHw = (instructionExpression >> 31 & 1) == 0 ? "W" : "X";
        int Rm = instructionExpression >> 16 & 0xF;
        int Rd = instructionExpression & 0xF;
        return String.format(ANSI_YELLOW + "sf == 0 && hw == 0x ? <Wt> else <Xt>\nMOV (register) <?d>, <?m>  |.....MOV (register) signature.......|\n" + ANSI_CYAN + "                            sf 0  1  0    1  0  1  0    0  0  0 |Rm..............|  0  0  0  0    0  0  1  1    1  1  1 |Rd.............|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n" + ANSI_YELLOW + "MOV(reg) " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "%s%d" + ANSI_RESET + "\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), sfHw, Rm, sfHw, Rd);
    }

    private static String printNOP(int instructionExpression) {
        return String.format(ANSI_YELLOW + "NOP                        |.....NOP signature..........................................................................................|\n" + ANSI_CYAN + "                            1  1  0  1    0  1  0  1    0  0  0  0    0  0  1  1    0  0  1  0    0  0  0  0    0  0  0  1    1  1  1  1 " + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n" + ANSI_YELLOW + "%s" + ANSI_RESET + "\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), instructionExpression == -721215457 ? "NOP" : "Some weird stuff");
    }

    private static String printTBZ(int instructionExpression, int offset) {
        int xwSelector = instructionExpression >> 31 & 1;
        int imm = instructionExpression >> 18 & 0x1F;
        int Rt = instructionExpression & 0x1F;
        int label = offset + (instructionExpression >> 5 & 0x3FFF) * 4 & 0xFFFFF;
        return String.format(ANSI_YELLOW + "sf == 0 && hw == 0x ? <Wt> else <Xt>\nTBZ <?t>,#<imm>, <label>   |.....TBZ signature.......|\n" + ANSI_CYAN + "                            b5 0  1  1    0  1  1  0   |b40.............|imm14.........................................||Rt.............|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n" + ANSI_YELLOW + "TBZ " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ", " + ANSI_PURPLE + "%x" + ANSI_RESET + "\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), xwSelector == 0 ? "w" : "x", Rt, imm, label);
    }

    private static String printBConditional(int instructionExpression, int offset) {
        int conditionalJumpLocation = (instructionExpression >> 4 & 0x7FFFF) * 4 + offset & 0xFFFFF;
        return String.format(ANSI_YELLOW + "B.%s <label>               |...B.cond signature.......|\n" + ANSI_CYAN + "                            0  1  0  1    0  1  0  0   |imm19..........................................................| 0   |.condit...|" + ANSI_RESET + "\n" + ANSI_GREEN + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n" + ANSI_YELLOW + "B.%s " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", BinToAsmPrinter.getBConditionalMarker(instructionExpression & 0xF), BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression), BinToAsmPrinter.getBConditionalMarker(instructionExpression & 0xF), conditionalJumpLocation, conditionalJumpLocation + 256);
    }

    private static String printUnknown(int instructionExpression) {
        return String.format(ANSI_RED + "                            31 30 29 28   27 26 25 24   23 22 21 20   19 18 17 16   15 14 13 12   11 10 9  8    7  6  5  4    3  2  1  0 " + ANSI_RESET + "\nInstruction         (BE) :  %s | %s\n", BinToAsmPrinter.intAsBinString(instructionExpression), BinToAsmPrinter.intAsHexString(instructionExpression));
    }

    private static String getBConditionalMarker(int cond) {
        switch (cond) {
            case 0: {
                return "EQ";
            }
            case 1: {
                return "NE";
            }
            case 2: {
                return "CS";
            }
            case 3: {
                return "CC";
            }
            case 4: {
                return "MI";
            }
            case 5: {
                return "PL";
            }
            case 6: {
                return "VS";
            }
            case 7: {
                return "VC";
            }
            case 8: {
                return "HI";
            }
            case 9: {
                return "LS";
            }
            case 10: {
                return "GE";
            }
            case 11: {
                return "LT";
            }
            case 12: {
                return "GT";
            }
            case 13: {
                return "LE";
            }
            case 14: {
                return "AL";
            }
        }
        return "??";
    }

    private static String printCBZSimplified(int instructionExpression, int offset) {
        int conditionalJumpLocation = (instructionExpression >> 5 & 0x7FFFF) * 4 + offset & 0xFFFFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   CBZ         " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (" + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, instructionExpression >> 31 == 0 ? "w" : "x", instructionExpression & 0x1F, conditionalJumpLocation, conditionalJumpLocation + 256);
    }

    private static String printCBNZSimplified(int instructionExpression, int offset) {
        int conditionalJumpLocation = (instructionExpression >> 5 & 0x7FFFF) * 4 + offset & 0xFFFFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   CBNZ        " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (" + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, instructionExpression >> 31 == 0 ? "w" : "x", instructionExpression & 0x1F, conditionalJumpLocation, conditionalJumpLocation + 256);
    }

    private static String printBSimplified(int instructionExpression, int offset) {
        int conditionalJumpLocationPatch = (instructionExpression & 0x3FFFFFF) * 4 + offset & 0xFFFFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   B           " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, conditionalJumpLocationPatch, conditionalJumpLocationPatch + 256);
    }

    private static String printBLSimplified(int instructionExpression, int offset) {
        int conditionalJumpLocationPatch = (instructionExpression & 0x3FFFFFF) * 4 + offset & 0xFFFFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   BL          " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, conditionalJumpLocationPatch, conditionalJumpLocationPatch + 256);
    }

    private static String printMOVSimplified(int instructionExpression, int offset) {
        int imm16 = instructionExpression >> 5 & 0xFFFF;
        int sfHw = instructionExpression >> 22 & 1;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   MOV         " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, sfHw == 0 ? "w" : "x", instructionExpression & 0x1F, imm16);
    }

    private static String printNOPSimplified(int instructionExpression, int offset) {
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   NOP           " + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression);
    }

    private static String printTBZSimplified(int instructionExpression, int offset) {
        int xwSelector = instructionExpression >> 31 & 1;
        int imm = instructionExpression >> 18 & 0x1F;
        int Rt = instructionExpression & 0x1F;
        int label = offset + (instructionExpression >> 5 & 0x3FFF) * 4;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   TBZ         " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ", " + ANSI_PURPLE + "%x" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, xwSelector == 0 ? "w" : "x", Rt, imm, label);
    }

    private static String printBConditionalSimplified(int instructionExpression, int offset) {
        int conditionalJumpLocation = (instructionExpression >> 4 & 0x7FFFF) * 4 + offset & 0xFFFFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   B.%s        " + ANSI_BLUE + "#0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ")\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, BinToAsmPrinter.getBConditionalMarker(instructionExpression & 0xF), conditionalJumpLocation, conditionalJumpLocation + 256);
    }

    private static String printImTooLazy(String name, int instructionExpression, int offset) {
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   " + name + "           . . . \n" + ANSI_RESET, offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression);
    }

    private static String printSUBSimplified(int instructionExpression, int offset) {
        String wx = instructionExpression >> 31 == 0 ? "W" : "X";
        int Rt = instructionExpression & 0x1F;
        int Rn = instructionExpression >> 5 & 0x1F;
        int imm12 = instructionExpression >> 10 & 0xFFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   SUB (imm)   " + ANSI_GREEN + "%s%d, " + ANSI_BLUE + "%s%d, #0x%x" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, wx, Rt, wx, Rn, imm12);
    }

    private static String printMOVRegisterSimplified(int instructionExpression, int offset) {
        String sfHw = (instructionExpression >> 31 & 1) == 0 ? "W" : "X";
        int Rm = instructionExpression >> 16 & 0x1F;
        int Rd = instructionExpression & 0x1F;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   MOV (reg)   " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "%s%d" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, sfHw, Rm, sfHw, Rd);
    }

    private static String printCMNSimplified(int instructionExpression, int offset) {
        int Rn = instructionExpression >> 5 & 0x1F;
        int imm = instructionExpression >> 10 & 0xFFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   CMN         " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "#0x%x" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, instructionExpression >> 31 == 0 ? "w" : "x", Rn, imm);
    }

    private static String printLRDImmUnsignSimplified(int instructionExpression, int offset) {
        String wx = instructionExpression >> 31 == 0 ? "W" : "X";
        int Rt = instructionExpression & 0x1F;
        int Rn = instructionExpression >> 5 & 0xF;
        int imm12 = (instructionExpression >> 10 & 0xFFF) * 8;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   LDR(imm)    " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "[%s%d, #0x%x]" + ANSI_RESET + "     (note: unsigned offset)\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, wx, Rt, wx, Rn, imm12);
    }

    private static String printLRDBImmUnsignSimplified(int instructionExpression, int offset) {
        String wx = instructionExpression >> 31 == 0 ? "W" : "X";
        int Rt = instructionExpression & 0x1F;
        int Rn = instructionExpression >> 5 & 0xF;
        int imm12 = (instructionExpression >> 10 & 0xFFF) * 8;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   LDRB(imm)   " + ANSI_GREEN + "%s%d " + ANSI_BLUE + "[%s%d, #0x%x]" + ANSI_RESET + "     (note: unsigned offset)\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, wx, Rt, wx, Rn, imm12);
    }

    private static String printCMPSimplified(int instructionExpression, int offset) {
        String sf = instructionExpression >> 31 == 0 ? "W" : "X";
        int Rn = instructionExpression >> 5 & 0x1F;
        int conditionalJumpLocation = instructionExpression >> 10 & 0xFFF;
        int LSL = (instructionExpression >> 22 & 1) == 1 ? 12 : 0;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   CMP         " + ANSI_GREEN + sf + "%d," + ANSI_BLUE + "0x%x" + ANSI_RESET + " (Real: " + ANSI_BLUE + "#0x%x" + ANSI_RESET + ") " + ANSI_PURPLE + "LSL #%d" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, Rn, conditionalJumpLocation, conditionalJumpLocation + 256, LSL);
    }

    private static String printCMPShiftedRegisterSimplified(int instructionExpression, int offset) {
        String sf = instructionExpression >> 31 == 0 ? "W" : "X";
        int Rn = instructionExpression >> 5 & 0x1F;
        int Rm = instructionExpression >> 16 & 0x1F;
        int imm6 = instructionExpression >> 10 & 0x3F;
        int LSL = instructionExpression >> 22 & 3;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   CMP (sr)    " + ANSI_GREEN + sf + "%d," + ANSI_BLUE + sf + "%d " + ANSI_BLUE + (switch (LSL) {
            case 0 -> "LSL";
            case 1 -> "LSR";
            case 2 -> "ASR";
            case 3 -> "RESERVED";
            default -> "?";
        }) + ANSI_PURPLE + " %d" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, Rn, Rm, imm6);
    }

    private static String printANDSimplified(int instructionExpression, int offset) {
        String sf = instructionExpression >> 31 == 0 ? "W" : "X";
        int Rn = instructionExpression & 0x1F;
        int Rd = instructionExpression >> 5 & 0x1F;
        int imm = sf.equals("W") ? instructionExpression >> 10 & 0xFFF : instructionExpression >> 10 & 0x1FFF;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   AND         " + ANSI_GREEN + sf + "%d, " + ANSI_BLUE + sf + "%d" + ANSI_PURPLE + " # ??? 0b%s " + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, Rn, Rd, Converter.intToBinaryString(imm));
    }

    private static String printRetSimplified(int instructionExpression, int offset) {
        int Xn = instructionExpression >> 5 & 0x1F;
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   RET        " + ANSI_GREEN + " X%d" + ANSI_RESET + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression, Xn == 0 ? 30 : Xn);
    }

    private static String printUnknownSimplified(int instructionExpression, int offset) {
        return String.format("%06x 7100%06x " + ANSI_CYAN + "%08x (%08x)" + ANSI_YELLOW + "   ???          0b" + ANSI_RESET + Converter.intToBinaryString(instructionExpression) + "\n", offset + 256, offset, Integer.reverseBytes(instructionExpression), instructionExpression);
    }

    private static String intAsBinString(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 31; i >= 0; --i) {
            int mask = 1 << i;
            result.append((number & mask) != 0 ? "1" : "0");
            result.append("  ");
            if (i % 4 != 0) continue;
            result.append("  ");
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    private static String intAsHexString(int number) {
        number = Integer.reverseBytes(number);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i <= 3; ++i) {
            int mask = 255 << i * 8;
            result.append(String.format("%02x", (byte)((number & mask) >> i * 8)));
            result.append(" ");
        }
        result.replace(result.length() - 1, result.length(), "");
        return result.toString();
    }

    static {
        boolean notWindows;
        boolean bl = notWindows = !System.getProperty("os.name").toLowerCase().contains("windows");
        if (notWindows && NSLMain.isCli) {
            ANSI_RESET = "\u001b[0m";
            ANSI_GREEN = "\u001b[32m";
            ANSI_BLUE = "\u001b[34m";
            ANSI_YELLOW = "\u001b[33m";
            ANSI_PURPLE = "\u001b[35m";
            ANSI_CYAN = "\u001b[36m";
            ANSI_RED = "\u001b[31m";
        } else {
            ANSI_CYAN = "";
            ANSI_PURPLE = "";
            ANSI_YELLOW = "";
            ANSI_BLUE = "";
            ANSI_GREEN = "";
            ANSI_RED = "";
            ANSI_RESET = "";
        }
    }
}

