/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb.gl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import nsusbloader.MediatorControl;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.helpers.NSSplitReader;
import nsusbloader.com.usb.TransferModule;
import nsusbloader.com.usb.gl.Converters;
import nsusbloader.com.usb.gl.GlString;
import nsusbloader.com.usb.gl.GlString010;
import nsusbloader.com.usb.gl.GoldleafCmd;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;

public class GoldLeaf_010
extends TransferModule {
    private static final int PACKET_SIZE = 4096;
    public static final byte[] EXCEPTION_CAUGHT = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, -15, -70}, 4096);
    public static final byte[] INVALID_INDEX = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, -14, -70}, 4096);
    public static final byte[] SELECTION_CANCELLED = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, -12, -70}, 4096);
    private static final byte[] CMD_GLCO_SUCCESS_FLAG = new byte[]{71, 76, 67, 79, 0, 0, 0, 0};
    private static final byte[] CMD_GLCO_SUCCESS = Arrays.copyOf(new byte[]{71, 76, 67, 79, 0, 0, 0, 0}, 4096);
    private final byte[] GL_OBJECT_TYPE_FILE = new byte[]{1, 0, 0, 0};
    private final byte[] GL_OBJECT_TYPE_DIR = new byte[]{2, 0, 0, 0};
    private final boolean nspFilter;
    private String recentPath;
    private String[] recentDirs;
    private String[] recentFiles;
    private final String[] nspMapKeySetIndexes;
    protected String openReadFileNameAndPath;
    protected RandomAccessFile randAccessFile;
    protected NSSplitReader splitReader;
    private final HashMap<String, BufferedOutputStream> writeFilesMap = new HashMap();
    protected long virtDriveSize;
    private final HashMap<String, Long> splitFileSize = new HashMap();
    private final boolean isWindows = System.getProperty("os.name").contains("Windows");
    protected final String homePath = System.getProperty("user.home");
    protected File selectedFile;

    public GoldLeaf_010(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter logPrinter, boolean nspFilter) {
        super(handler, nspMap, task, logPrinter);
        this.nspFilter = nspFilter;
        this.printWelcomeMessage();
        this.nspMapKeySetIndexes = nspMap.keySet().toArray(new String[0]);
        for (File nspFile : nspMap.values()) {
            if (nspFile.isDirectory()) {
                File[] subFiles = nspFile.listFiles((file, name) -> name.matches("[0-9]{2}"));
                assert (subFiles != null);
                long size = 0L;
                for (File subFile : subFiles) {
                    size += subFile.length();
                }
                this.virtDriveSize += size;
                this.splitFileSize.put(nspFile.getName(), size);
                continue;
            }
            this.virtDriveSize += nspFile.length();
        }
        if (this.workLoop()) {
            return;
        }
        for (BufferedOutputStream bufferedOutputStream : this.writeFilesMap.values()) {
            try {
                bufferedOutputStream.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
        this.closeOpenedReadFilesGl();
    }

    protected void printWelcomeMessage() {
        this.print("=========== GoldLeaf v0.10-1.0.0 ===========\n\tVIRT:/ equals files added into the application\n\tHOME:/ equals " + this.homePath, EMsgType.INFO);
    }

    protected boolean workLoop() {
        byte[] readByte;
        block18: while ((readByte = this.readGL()) != null) {
            if (this.notGLCI(readByte)) continue;
            switch (GoldleafCmd.get(readByte[4])) {
                case GetDriveCount: {
                    if (!this.getDriveCount()) continue block18;
                    return false;
                }
                case GetDriveInfo: {
                    if (!this.getDriveInfo(Converters.arrToIntLE(readByte, 8))) continue block18;
                    return false;
                }
                case GetSpecialPathCount: {
                    if (!this.getSpecialPathCount()) continue block18;
                    return false;
                }
                case GetSpecialPath: {
                    if (!this.getSpecialPath(Converters.arrToIntLE(readByte, 8))) continue block18;
                    return false;
                }
                case GetDirectoryCount: {
                    if (!this.getDirectoryOrFileCount(this.readString(readByte, 8).toString(), true)) continue block18;
                    return false;
                }
                case GetFileCount: {
                    if (!this.getDirectoryOrFileCount(this.readString(readByte, 8).toString(), false)) continue block18;
                    return false;
                }
                case GetDirectory: {
                    GlString glString1 = this.readString(readByte, 8);
                    if (!this.getDirectory(glString1.toString(), Converters.arrToIntLE(readByte, glString1.length() + 12))) continue block18;
                    return false;
                }
                case GetFile: {
                    GlString glString1 = this.readString(readByte, 8);
                    if (!this.getFile(glString1.toString(), Converters.arrToIntLE(readByte, glString1.length() + 12))) continue block18;
                    return false;
                }
                case StatPath: {
                    if (!this.statPath(this.readString(readByte, 8).toString())) continue block18;
                    return false;
                }
                case Rename: {
                    GlString glString1 = this.readString(readByte, 8);
                    GlString glString2 = this.readString(readByte, 12 + glString1.length());
                    if (!this.rename(glString1.toString(), glString2.toString())) continue block18;
                    return false;
                }
                case Delete: {
                    if (!this.delete(this.readString(readByte, 8).toString())) continue block18;
                    return false;
                }
                case Create: {
                    if (!this.create(this.readString(readByte, 8).toString(), readByte[8])) continue block18;
                    return false;
                }
                case ReadFile: {
                    GlString glString1 = this.readString(readByte, 8);
                    if (!this.readFile(glString1.toString(), Converters.arrToLongLE(readByte, 12 + glString1.length()), Converters.arrToLongLE(readByte, 12 + glString1.length() + 8))) continue block18;
                    return false;
                }
                case WriteFile: {
                    if (!this.writeFile(this.readString(readByte, 8).toString())) continue block18;
                    return false;
                }
                case SelectFile: {
                    if (!this.selectFile()) continue block18;
                    return false;
                }
                case StartFile: 
                case EndFile: {
                    if (!this.startOrEndFile()) continue block18;
                    return false;
                }
            }
            this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Unknown command: " + readByte[4] + " [it's a very bad sign]");
        }
        return true;
    }

    protected GlString readString(byte[] readByte, int startPosition) {
        return new GlString010(readByte, startPosition);
    }

    protected boolean notGLCI(byte[] inputBytes) {
        return !"GLCI".equals(new String(inputBytes, 0, 4, StandardCharsets.US_ASCII));
    }

    protected boolean startOrEndFile() {
        return this.writeGL_PASS("GL Handle 'StartFile' command");
    }

    protected boolean getDriveCount() {
        return this.writeGL_PASS(Converters.intToArrLE(2), "GL Handle 'ListDrives' command");
    }

    protected boolean getDriveInfo(int driveNo) {
        long totalSizeLong;
        byte[] totalFreeSpace;
        byte[] driveLetterLen;
        byte[] driveLetter;
        byte[] driveLabelLen;
        byte[] driveLabel;
        if (driveNo < 0 || driveNo > 1) {
            return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDriveInfo' command [no such drive]");
        }
        if (driveNo == 0) {
            driveLabel = "Virtual".getBytes(StandardCharsets.UTF_8);
            driveLabelLen = Converters.intToArrLE(driveLabel.length);
            driveLetter = "VIRT".getBytes(StandardCharsets.UTF_8);
            driveLetterLen = Converters.intToArrLE(driveLetter.length);
            totalFreeSpace = new byte[4];
            totalSizeLong = this.virtDriveSize;
        } else {
            driveLabel = "Home".getBytes(StandardCharsets.UTF_8);
            driveLabelLen = Converters.intToArrLE(driveLabel.length);
            driveLetter = "HOME".getBytes(StandardCharsets.UTF_8);
            driveLetterLen = Converters.intToArrLE(driveLetter.length);
            File userHomeDir = new File(System.getProperty("user.home"));
            totalFreeSpace = Arrays.copyOfRange(Converters.longToArrLE(userHomeDir.getFreeSpace()), 0, 4);
            totalSizeLong = userHomeDir.getTotalSpace();
        }
        byte[] totalSize = Arrays.copyOfRange(Converters.longToArrLE(totalSizeLong), 0, 4);
        List<byte[]> command = Arrays.asList(driveLabelLen, driveLabel, driveLetterLen, driveLetter, totalFreeSpace, totalSize);
        return this.writeGL_PASS(command, "GL Handle 'GetDriveInfo' command");
    }

    protected boolean getSpecialPathCount() {
        return this.writeGL_PASS(Converters.intToArrLE(0), "GL Handle 'SpecialPathCount' command");
    }

    protected boolean getSpecialPath(int specialPathNo) {
        return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'SpecialPath' command [not supported]");
    }

    protected boolean getDirectoryOrFileCount(String glFileName, boolean isGetDirectoryCount) {
        if (glFileName.equals("VIRT:/")) {
            return isGetDirectoryCount ? this.writeGL_PASS("GL Handle 'GetDirectoryCount' command") : this.writeGL_PASS(Converters.intToArrLE(this.nspMap.size()), "GL Handle 'GetFileCount' command Count = " + this.nspMap.size());
        }
        if (glFileName.startsWith("HOME:/")) {
            String[] filesOrDirs;
            String path = this.decodeGlPath(glFileName);
            File pathDir = new File(path);
            if (this.notExistsOrDirectory(pathDir)) {
                return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'GetDirectoryOrFileCount' command [doesn't exist or not a folder] " + pathDir);
            }
            this.recentPath = path;
            String[] stringArray = filesOrDirs = isGetDirectoryCount ? pathDir.list(this::isDirectoryAndNotHidden) : pathDir.list(this::isFileAndNotHidden);
            if (filesOrDirs == null) {
                return this.writeGL_PASS("GL Handle 'GetDirectoryOrFileCount' command");
            }
            Arrays.sort(filesOrDirs, String.CASE_INSENSITIVE_ORDER);
            if (isGetDirectoryCount) {
                this.recentDirs = filesOrDirs;
            } else {
                this.recentFiles = filesOrDirs;
            }
            return this.writeGL_PASS(Converters.intToArrLE(filesOrDirs.length), "GL Handle 'GetDirectoryOrFileCount' command");
        }
        if (glFileName.startsWith("SPEC:/")) {
            if (isGetDirectoryCount) {
                return this.writeGL_PASS("GL Handle 'GetDirectoryCount' command");
            }
            if (this.selectedFile != null) {
                return this.writeGL_PASS(Converters.intToArrLE(1), "GL Handle 'GetFileCount' command Count = 1");
            }
            return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'GetDirectoryOrFileCount' command [unknown drive request] (file) - " + glFileName);
        }
        return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'GetDirectoryOrFileCount' command [unknown drive request] " + (isGetDirectoryCount ? "(dir) - " : "(file) - ") + glFileName);
    }

    protected boolean getDirectory(String dirName, int subDirNo) {
        if (dirName.startsWith("HOME:/")) {
            dirName = this.decodeGlPath(dirName);
            ArrayList<byte[]> command = new ArrayList<byte[]>();
            if (dirName.equals(this.recentPath) && this.recentDirs != null && this.recentDirs.length != 0) {
                byte[] dirNameBytes = this.recentDirs[subDirNo].getBytes(StandardCharsets.UTF_8);
                command.add(Converters.intToArrLE(dirNameBytes.length));
                command.add(dirNameBytes);
            } else {
                File pathDir = new File(dirName);
                if (this.notExistsOrDirectory(pathDir)) {
                    return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDirectory' command [doesn't exist or not a folder]");
                }
                this.recentPath = dirName;
                this.recentDirs = pathDir.list(this::isDirectoryAndNotHidden);
                if (this.recentDirs != null && this.recentDirs.length > subDirNo) {
                    Arrays.sort(this.recentFiles, String.CASE_INSENSITIVE_ORDER);
                    byte[] dirBytesName = this.recentDirs[subDirNo].getBytes(StandardCharsets.UTF_8);
                    command.add(Converters.intToArrLE(dirBytesName.length));
                    command.add(dirBytesName);
                } else {
                    return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDirectory' command [doesn't exist or not a folder]");
                }
            }
            return this.writeGL_PASS(command, "GL Handle 'GetDirectory' command.");
        }
        return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDirectory' command for virtual drive [no folders support]");
    }

    protected boolean getFile(String glDirName, int subDirNo) {
        LinkedList<byte[]> command = new LinkedList<byte[]>();
        if (glDirName.startsWith("HOME:/")) {
            String dirName = this.decodeGlPath(glDirName);
            if (dirName.equals(this.recentPath) && this.recentFiles != null && this.recentFiles.length != 0) {
                byte[] fileNameBytes = this.recentFiles[subDirNo].getBytes(StandardCharsets.UTF_8);
                command.add(Converters.intToArrLE(fileNameBytes.length));
                command.add(fileNameBytes);
            } else {
                File pathDir = new File(dirName);
                if (this.notExistsOrDirectory(pathDir)) {
                    this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetFile' command [doesn't exist or not a folder]");
                }
                this.recentPath = dirName;
                this.recentFiles = pathDir.list(this::isFileAndNotHidden);
                if (this.recentFiles != null && this.recentFiles.length > subDirNo) {
                    Arrays.sort(this.recentFiles, String.CASE_INSENSITIVE_ORDER);
                    byte[] fileNameBytes = this.recentFiles[subDirNo].getBytes(StandardCharsets.UTF_8);
                    command.add(Converters.intToArrLE(fileNameBytes.length));
                    command.add(fileNameBytes);
                } else {
                    return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetFile' command [doesn't exist or not a folder]");
                }
            }
            return this.writeGL_PASS(command, "GL Handle 'GetFile' command.");
        }
        if (glDirName.equals("VIRT:/") && !this.nspMap.isEmpty()) {
            byte[] fileNameBytes = this.nspMapKeySetIndexes[subDirNo].getBytes(StandardCharsets.UTF_8);
            command.add(Converters.intToArrLE(fileNameBytes.length));
            command.add(fileNameBytes);
            return this.writeGL_PASS(command, "GL Handle 'GetFile' command.");
        }
        if (glDirName.equals("SPEC:/") && this.selectedFile != null) {
            byte[] fileNameBytes = this.selectedFile.getName().getBytes(StandardCharsets.UTF_8);
            command.add(Converters.intToArrLE(fileNameBytes.length));
            command.add(fileNameBytes);
            return this.writeGL_PASS(command, "GL Handle 'GetFile' command.");
        }
        return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetFile' command for virtual drive [no folders support?]");
    }

    protected boolean statPath(String glFileName) {
        ArrayList<byte[]> command = new ArrayList<byte[]>();
        if (glFileName.startsWith("HOME:/")) {
            File fileDirElement = new File(this.decodeGlPath(glFileName));
            if (fileDirElement.exists()) {
                if (fileDirElement.isDirectory()) {
                    command.add(this.GL_OBJECT_TYPE_DIR);
                } else {
                    command.add(this.GL_OBJECT_TYPE_FILE);
                    command.add(Converters.longToArrLE(fileDirElement.length()));
                }
                return this.writeGL_PASS(command, "GL Handle 'StatPath' command for " + glFileName);
            }
        } else if (glFileName.startsWith("VIRT:/")) {
            String fileName = glFileName.replaceFirst("^.*?:/", "");
            if (this.nspMap.containsKey(fileName)) {
                command.add(this.GL_OBJECT_TYPE_FILE);
                if (((File)this.nspMap.get(fileName)).isDirectory()) {
                    command.add(Converters.longToArrLE(this.splitFileSize.get(fileName)));
                } else {
                    command.add(Converters.longToArrLE(((File)this.nspMap.get(fileName)).length()));
                }
                return this.writeGL_PASS(command, "GL Handle 'StatPath' command for " + glFileName);
            }
        } else if (glFileName.startsWith("SPEC:/")) {
            String fileName = glFileName.replaceFirst("^.*?:/", "");
            if (this.selectedFile.getName().equals(fileName)) {
                command.add(this.GL_OBJECT_TYPE_FILE);
                command.add(Converters.longToArrLE(this.selectedFile.length()));
                return this.writeGL_PASS(command, "GL Handle 'StatPath' command for " + glFileName);
            }
        }
        return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'StatPath' command [no such path]: " + glFileName);
    }

    protected boolean rename(String glFileName, String glNewFileName) {
        if (glFileName.startsWith("HOME:/")) {
            this.recentPath = null;
            this.recentFiles = null;
            this.recentDirs = null;
            String fileName = this.decodeGlPath(glFileName);
            File newFile = new File(this.decodeGlPath(glNewFileName));
            try {
                if (new File(fileName).renameTo(newFile)) {
                    return this.writeGL_PASS("GL Handle 'Rename' command.");
                }
            }
            catch (SecurityException se) {
                return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Rename' command failed:\n\t" + se.getMessage());
            }
        }
        return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Rename' command is not supported for virtual drive, selected files, if file with such name already exists in folder, read-only directories");
    }

    protected boolean delete(String glFileName) {
        if (!glFileName.startsWith("HOME:/")) {
            return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Delete' command [not supported for virtual drive/wrong drive/read-only directory] " + glFileName);
        }
        File file = new File(this.decodeGlPath(glFileName));
        try {
            if (file.delete()) {
                return this.writeGL_PASS("GL Handle 'Rename' command.");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Create' command [unknown drive/read-only directory]");
    }

    protected boolean create(String glFileName, byte type) {
        if (!glFileName.startsWith("HOME:/")) {
            return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Create' command [not supported for virtual drive/wrong drive/read-only directory]" + glFileName);
        }
        File file = new File(this.decodeGlPath(glFileName));
        try {
            boolean result;
            switch (type) {
                case 1: {
                    boolean bl = file.createNewFile();
                    break;
                }
                case 2: {
                    boolean bl = file.mkdir();
                    break;
                }
                default: {
                    boolean bl = result = false;
                }
            }
            if (result) {
                return this.writeGL_PASS("GL Handle 'Create' command.");
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'Create' command [unknown drive/read-only directory]");
    }

    protected boolean readFile(String glFileName, long offset, long size) {
        String fileName = glFileName.replaceFirst("^.*?:/", "");
        if (glFileName.startsWith("VIRT:/")) {
            String fNamePath = ((File)this.nspMap.get(fileName)).getAbsolutePath();
            if (this.openReadFileNameAndPath == null || !this.openReadFileNameAndPath.equals(fNamePath)) {
                if (this.openReadFileNameAndPath != null) {
                    this.closeRAFandSplitReader();
                }
                try {
                    File tempFile = (File)this.nspMap.get(fileName);
                    if (tempFile.isDirectory()) {
                        this.randAccessFile = null;
                        this.splitReader = new NSSplitReader(tempFile, 0L);
                    } else {
                        this.splitReader = null;
                        this.randAccessFile = new RandomAccessFile(tempFile, "r");
                    }
                    this.openReadFileNameAndPath = fNamePath;
                }
                catch (IOException | NullPointerException ioe) {
                    return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command\n\t" + ioe.getMessage());
                }
            }
        } else {
            String filePath;
            if (glFileName.startsWith("SPEC:/")) {
                if (!fileName.equals(this.selectedFile.getName())) {
                    return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command\n\trequested != selected:\n\t" + glFileName + "\n\t" + this.selectedFile);
                }
                filePath = this.selectedFile.getAbsolutePath();
            } else {
                filePath = this.decodeGlPath(glFileName);
            }
            if (this.openReadFileNameAndPath == null || !this.openReadFileNameAndPath.equals(filePath)) {
                if (this.openReadFileNameAndPath != null) {
                    this.closeRAF();
                }
                try {
                    this.randAccessFile = new RandomAccessFile(filePath, "r");
                    this.openReadFileNameAndPath = filePath;
                }
                catch (IOException | NullPointerException ioe) {
                    return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command\n\t" + ioe.getMessage());
                }
            }
        }
        try {
            int bytesRead;
            byte[] chunk = new byte[(int)size];
            if (this.randAccessFile == null) {
                this.splitReader.seek(offset);
                bytesRead = this.splitReader.read(chunk);
            } else {
                this.randAccessFile.seek(offset);
                bytesRead = this.randAccessFile.read(chunk);
            }
            if (bytesRead != (int)size) {
                return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' command [CMD]\n         At offset: " + offset + "\n         Requested: " + size + "\n         Received:  " + bytesRead);
            }
            if (this.writeGL_PASS(Converters.longToArrLE(size), "GL Handle 'ReadFile' command [CMD]")) {
                return true;
            }
            if (this.writeToUsb(chunk)) {
                this.print("GL Handle 'ReadFile' command", EMsgType.FAIL);
                return true;
            }
            return false;
        }
        catch (Exception ioe) {
            this.closeOpenedReadFilesGl();
            return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'ReadFile' transfer chain\n\t" + ioe.getMessage());
        }
    }

    boolean writeFile(String glFileName) {
        byte[] transferredData;
        if (glFileName.startsWith("VIRT:/")) {
            return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'WriteFile' command [not supported for virtual drive]");
        }
        if (!this.writeFilesMap.containsKey(glFileName = this.decodeGlPath(glFileName))) {
            try {
                this.writeFilesMap.put(glFileName, new BufferedOutputStream(new FileOutputStream(glFileName, true)));
            }
            catch (IOException ioe) {
                return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'WriteFile' command [IOException]\n\t" + ioe.getMessage());
            }
        }
        if ((transferredData = this.readGL_file()) == null) {
            this.print("GL Handle 'WriteFile' command [1/1]", EMsgType.FAIL);
            return true;
        }
        try {
            this.writeFilesMap.get(glFileName).write(transferredData, 0, transferredData.length);
        }
        catch (IOException ioe) {
            return this.writeGL_FAIL(EXCEPTION_CAUGHT, "GL Handle 'WriteFile' command [1/1]\n\t" + ioe.getMessage());
        }
        return this.writeGL_PASS("GL Handle 'WriteFile' command");
    }

    protected boolean selectFile() {
        File selectedFile = CompletableFuture.supplyAsync(() -> {
            FileChooser fChooser = new FileChooser();
            fChooser.setTitle(MediatorControl.INSTANCE.getResourceBundle().getString("btn_OpenFile"));
            fChooser.setInitialDirectory(new File(System.getProperty("user.home")));
            fChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("*", "*"));
            return fChooser.showOpenDialog(null);
        }, Platform::runLater).join();
        if (selectedFile == null) {
            this.selectedFile = null;
            return this.writeGL_FAIL(SELECTION_CANCELLED, "GL Handle 'SelectFile' command: Nothing selected");
        }
        byte[] selectedFileNameBytes = ("SPEC:/" + selectedFile.getName()).getBytes(StandardCharsets.UTF_8);
        List<byte[]> command = Arrays.asList(Converters.intToArrLE(selectedFileNameBytes.length), selectedFileNameBytes);
        if (this.writeGL_PASS(command, "GL Handle 'SelectFile' command")) {
            this.selectedFile = null;
            return true;
        }
        this.selectedFile = selectedFile;
        return false;
    }

    protected String decodeGlPath(String glPath) {
        if (this.isWindows) {
            glPath = glPath.replace('/', '\\');
        }
        return this.homePath + glPath.substring(5);
    }

    private boolean isFileAndNotHidden(File parent, String child) {
        File entry = new File(parent, child);
        return !entry.isDirectory() && (this.nspFilter ? child.toLowerCase().endsWith(".nsp") : !entry.isHidden());
    }

    private boolean isDirectoryAndNotHidden(File parent, String child) {
        File dir = new File(parent, child);
        return dir.isDirectory() && !dir.isHidden();
    }

    private boolean notExistsOrDirectory(File pathDir) {
        return !pathDir.exists() || !pathDir.isDirectory();
    }

    protected void closeOpenedReadFilesGl() {
        if (this.openReadFileNameAndPath != null) {
            this.closeRAFandSplitReader();
            this.openReadFileNameAndPath = null;
            this.randAccessFile = null;
            this.splitReader = null;
        }
    }

    protected void closeRAFandSplitReader() {
        this.closeRAF();
        try {
            this.splitReader.close();
        }
        catch (IOException ioe_) {
            this.print("Unable to close: " + this.openReadFileNameAndPath + "\n\t" + ioe_.getMessage(), EMsgType.WARNING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void closeRAF() {
        try {
            this.randAccessFile.close();
        }
        catch (IOException ioe_) {
            this.print("Unable to close: " + this.openReadFileNameAndPath + "\n\t" + ioe_.getMessage(), EMsgType.WARNING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected byte[] readGL() {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(4096);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    byte[] receivedBytes = new byte[readBufTransferred.get()];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    this.closeOpenedReadFilesGl();
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [read]\n         Returned: " + LibUsb.errorName(result) + "\n         GL Execution stopped", EMsgType.FAIL);
            return null;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return null;
    }

    private byte[] readGL_file() {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(0x800000);
        IntBuffer readBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)-127, readBuffer, readBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    byte[] receivedBytes = new byte[readBufTransferred.get()];
                    readBuffer.get(receivedBytes);
                    return receivedBytes;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [read]\n         Returned: " + LibUsb.errorName(result) + "\n         GL Execution stopped", EMsgType.FAIL);
            return null;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return null;
    }

    protected boolean writeGL_PASS(String onFailureText) {
        if (this.writeToUsb(CMD_GLCO_SUCCESS)) {
            this.print(onFailureText, EMsgType.FAIL);
            return true;
        }
        return false;
    }

    protected boolean writeGL_PASS(byte[] message, String onFailureText) {
        boolean result = this.writeToUsb(ByteBuffer.allocate(4096).put(CMD_GLCO_SUCCESS_FLAG).put(message).array());
        if (result) {
            this.print(onFailureText, EMsgType.FAIL);
            return true;
        }
        return false;
    }

    protected boolean writeGL_PASS(List<byte[]> messages, String onFailureText) {
        ByteBuffer writeBuffer = ByteBuffer.allocate(4096).put(CMD_GLCO_SUCCESS_FLAG);
        messages.forEach(writeBuffer::put);
        if (this.writeToUsb(writeBuffer.array())) {
            this.print(onFailureText, EMsgType.FAIL);
            return true;
        }
        return false;
    }

    protected boolean writeGL_FAIL(byte[] failurePacket, String failureMessage) {
        if (this.writeToUsb(failurePacket)) {
            this.print(failureMessage, EMsgType.WARNING);
            return true;
        }
        this.print(failureMessage, EMsgType.FAIL);
        return false;
    }

    private boolean writeToUsb(byte[] message) {
        IntBuffer writeBufTransferred = IntBuffer.allocate(1);
        block4: while (!this.task.isCancelled()) {
            int result = LibUsb.bulkTransfer(this.handlerNS, (byte)1, ByteBuffer.allocateDirect(message.length).put(message), writeBufTransferred, 1000L);
            switch (result) {
                case 0: {
                    if (writeBufTransferred.get() == message.length) {
                        return false;
                    }
                    this.print("GL Data transfer issue [write]\n         Requested: " + message.length + "\n         Transferred: " + writeBufTransferred.get(), EMsgType.FAIL);
                    return true;
                }
                case -7: {
                    continue block4;
                }
            }
            this.print("GL Data transfer issue [write]\n         Returned: " + LibUsb.errorName(result) + "\n         GL Execution stopped", EMsgType.FAIL);
            return true;
        }
        this.print("GL Execution interrupted", EMsgType.INFO);
        return true;
    }
}

