/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.RomFs;

import java.io.File;
import libKonogonka.aesctr.InFileStreamProducer;
import libKonogonka.fs.ExportAble;
import libKonogonka.fs.RomFs.FileSystemEntry;
import libKonogonka.fs.RomFs.Level6Header;
import libKonogonka.fs.RomFs.RomFsConstruct;
import libKonogonka.fs.RomFs.view.DirectoryMetaTablePlainView;
import libKonogonka.fs.RomFs.view.FileMetaTablePlainView;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RomFsProvider
extends ExportAble {
    private static final Logger log = LogManager.getLogger(RomFsProvider.class);
    private final InFileStreamProducer producer;
    private final long level6Offset;
    private final Level6Header level6Header;
    private final FileSystemEntry rootEntry;
    private long mediaStartOffset;
    private final byte[] directoryMetadataTable;
    private final byte[] fileMetadataTable;

    public RomFsProvider(File decryptedFsImageFile, long level6offset) throws Exception {
        this.producer = new InFileStreamProducer(decryptedFsImageFile);
        RomFsConstruct construct = new RomFsConstruct(this.producer, level6offset);
        this.level6Offset = level6offset;
        this.level6Header = construct.getHeader();
        this.rootEntry = construct.getRootEntry();
        this.directoryMetadataTable = construct.getDirectoryMetadataTable();
        this.fileMetadataTable = construct.getFileMetadataTable();
    }

    public RomFsProvider(InFileStreamProducer producer, long level6Offset, long offsetPositionInFile, long mediaStartOffset) throws Exception {
        this.producer = producer;
        this.mediaStartOffset = mediaStartOffset;
        RomFsConstruct construct = new RomFsConstruct(producer, level6Offset, offsetPositionInFile);
        this.level6Offset = level6Offset;
        this.level6Header = construct.getHeader();
        this.rootEntry = construct.getRootEntry();
        this.directoryMetadataTable = construct.getDirectoryMetadataTable();
        this.fileMetadataTable = construct.getFileMetadataTable();
    }

    public long getLevel6Offset() {
        return this.level6Offset;
    }

    public Level6Header getHeader() {
        return this.level6Header;
    }

    public FileSystemEntry getRootEntry() {
        return this.rootEntry;
    }

    public boolean exportContent(String saveToLocation, FileSystemEntry entry) {
        try {
            if (!saveToLocation.endsWith(File.separator)) {
                saveToLocation = saveToLocation + File.separator;
            }
            if (entry.isDirectory()) {
                this.exportFolderContent(entry, saveToLocation);
            } else {
                this.exportSingleFile(entry, saveToLocation);
            }
        }
        catch (Exception e) {
            log.error(this.getFile().getName() + " export failure ", (Throwable)e);
            return false;
        }
        return true;
    }

    private void exportFolderContent(FileSystemEntry entry, String saveToLocation) throws Exception {
        File contentFile = new File(saveToLocation + entry.getName());
        contentFile.mkdirs();
        String currentDirPath = saveToLocation + entry.getName() + File.separator;
        for (FileSystemEntry fileEntry : entry.getContent()) {
            if (fileEntry.isDirectory()) {
                this.exportFolderContent(fileEntry, currentDirPath);
                continue;
            }
            this.exportSingleFile(fileEntry, currentDirPath);
        }
    }

    private void exportSingleFile(FileSystemEntry entry, String saveToLocation) throws Exception {
        try {
            this.stream = this.producer.produce();
            long skipBytes = entry.getOffset() + this.mediaStartOffset * 512L + this.level6Header.getFileDataOffset() + this.level6Offset;
            this.export(saveToLocation, entry.getName(), skipBytes, entry.getSize());
        }
        catch (Exception e) {
            throw new Exception(entry.getName() + ": " + e.getLocalizedMessage(), e);
        }
    }

    public InFileStreamProducer getStreamProducer(FileSystemEntry entry) throws Exception {
        if (entry.isDirectory()) {
            throw new Exception("Directory entries are not supported");
        }
        return this.producer.getSuccessor(entry.getOffset() + this.mediaStartOffset * 512L + this.level6Header.getFileDataOffset() + this.level6Offset);
    }

    public File getFile() {
        return this.producer.getFile();
    }

    public void printDebug() {
        this.level6Header.printDebugInfo();
        new DirectoryMetaTablePlainView(this.level6Header.getDirectoryMetadataTableLength(), this.directoryMetadataTable);
        new FileMetaTablePlainView(this.level6Header.getFileMetadataTableLength(), this.fileMetadataTable);
        this.rootEntry.printTreeForDebug();
    }
}

