/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.TIK;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import libKonogonka.Converter;

public class TIKProvider {
    private final byte[] sigType;
    private final byte[] signature;
    private final String Issuer;
    private final byte[] TitleKeyBlockStartingBytes;
    private final byte[] TitleKeyBlockEndingBytes;
    private final byte Unknown1;
    private final byte TitleKeyType;
    private final byte[] Unknown2;
    private final byte MasterKeyRevision;
    private final byte[] Unknown3;
    private final byte[] TicketId;
    private final byte[] DeviceId;
    private final byte[] RightsId;
    private final byte[] AccountId;
    private final byte[] Unknown4;

    public TIKProvider(File file) throws Exception {
        this(file, 0L);
    }

    public TIKProvider(File file, long offset) throws Exception {
        byte[] readChunk;
        if (file.length() - offset < 704L) {
            throw new Exception("File is too small.");
        }
        BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        if (bis.skip(offset) != offset) {
            bis.close();
            throw new Exception("Unable to skip requested range - " + offset);
        }
        this.sigType = new byte[4];
        if (bis.read(this.sigType) != 4) {
            bis.close();
            throw new Exception("Unable to read requested range - " + offset);
        }
        switch (Converter.getLEint(this.sigType, 0)) {
            case 65536: 
            case 65539: {
                readChunk = new byte[572];
                if (bis.read(readChunk) != 572) {
                    bis.close();
                    throw new Exception("Unable to read requested range - 0x23c");
                }
                this.signature = Arrays.copyOfRange(readChunk, 0, 512);
                break;
            }
            case 65537: 
            case 65540: {
                readChunk = new byte[316];
                if (bis.read(readChunk) != 316) {
                    bis.close();
                    throw new Exception("Unable to read requested range - 0x13c");
                }
                this.signature = Arrays.copyOfRange(readChunk, 0, 256);
                break;
            }
            case 65538: 
            case 65541: {
                readChunk = new byte[124];
                if (bis.read(readChunk) != 124) {
                    bis.close();
                    throw new Exception("Unable to read requested range - 0x7c");
                }
                this.signature = Arrays.copyOfRange(readChunk, 0, 60);
                break;
            }
            default: {
                bis.close();
                throw new Exception("Unknown ticket (Signature) type. Aborting.");
            }
        }
        readChunk = new byte[384];
        if (bis.read(readChunk) != 384) {
            bis.close();
            throw new Exception("Unable to read requested range - Ticket data");
        }
        bis.close();
        this.Issuer = new String(readChunk, 0, 64, StandardCharsets.UTF_8);
        this.TitleKeyBlockStartingBytes = Arrays.copyOfRange(readChunk, 64, 80);
        this.TitleKeyBlockEndingBytes = Arrays.copyOfRange(readChunk, 80, 320);
        this.Unknown1 = readChunk[320];
        this.TitleKeyType = readChunk[321];
        this.Unknown2 = Arrays.copyOfRange(readChunk, 322, 325);
        this.MasterKeyRevision = readChunk[325];
        this.Unknown3 = Arrays.copyOfRange(readChunk, 326, 336);
        this.TicketId = Arrays.copyOfRange(readChunk, 336, 344);
        this.DeviceId = Arrays.copyOfRange(readChunk, 344, 352);
        this.RightsId = Arrays.copyOfRange(readChunk, 352, 368);
        this.AccountId = Arrays.copyOfRange(readChunk, 368, 372);
        this.Unknown4 = Arrays.copyOfRange(readChunk, 372, 384);
    }

    public byte[] getSigType() {
        return this.sigType;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getIssuer() {
        return this.Issuer;
    }

    public byte[] getTitleKeyBlockStartingBytes() {
        return this.TitleKeyBlockStartingBytes;
    }

    public byte[] getTitleKeyBlockEndingBytes() {
        return this.TitleKeyBlockEndingBytes;
    }

    public byte getUnknown1() {
        return this.Unknown1;
    }

    public byte getTitleKeyType() {
        return this.TitleKeyType;
    }

    public byte[] getUnknown2() {
        return this.Unknown2;
    }

    public byte getMasterKeyRevision() {
        return this.MasterKeyRevision;
    }

    public byte[] getUnknown3() {
        return this.Unknown3;
    }

    public byte[] getTicketId() {
        return this.TicketId;
    }

    public byte[] getDeviceId() {
        return this.DeviceId;
    }

    public byte[] getRightsId() {
        return this.RightsId;
    }

    public byte[] getAccountId() {
        return this.AccountId;
    }

    public byte[] getUnknown4() {
        return this.Unknown4;
    }
}

