/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.usb.gl;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.usb.gl.Converters;
import nsusbloader.com.usb.gl.GoldLeaf_010;
import org.usb4java.DeviceHandle;

public class GoldLeaf_111
extends GoldLeaf_010 {
    public GoldLeaf_111(DeviceHandle handler, LinkedHashMap<String, File> nspMap, CancellableRunnable task, ILogPrinter logPrinter, boolean nspFilter) {
        super(handler, nspMap, task, logPrinter, nspFilter);
    }

    @Override
    protected void printWelcomeMessage() {
        this.print("=========== GoldLeaf v1.1.1 ===========\n\tVIRT:/ equals files added into the application\n\tHOME:/ equals " + this.homePath + "\n\tBE CAREFUL!\n\tDue to some strange behaviour with Goldleaf v1.1.1, you will see last menu entry 'Do not click (crashes Atmosphere)'\n\tYou should better not clicking on it", EMsgType.INFO);
    }

    @Override
    protected boolean getDriveCount() {
        return this.writeGL_PASS(Converters.intToArrLE(3), "GL Handle 'ListDrives' command");
    }

    @Override
    protected boolean getDriveInfo(int driveNo) {
        byte[] totalFreeSpace;
        byte[] driveLetterLen;
        byte[] driveLetter;
        byte[] driveLabelLen;
        byte[] driveLabel;
        if (driveNo < 0 || driveNo > 2) {
            return this.writeGL_FAIL(INVALID_INDEX, "GL Handle 'GetDriveInfo' command [no such drive]");
        }
        byte[] totalSize = Arrays.copyOfRange(Converters.longToArrLE(switch (driveNo) {
            case 0 -> {
                driveLabel = "Home".getBytes(StandardCharsets.UTF_8);
                driveLabelLen = Converters.intToArrLE(driveLabel.length);
                driveLetter = "VIRT".getBytes(StandardCharsets.UTF_8);
                driveLetterLen = Converters.intToArrLE(driveLetter.length);
                totalFreeSpace = new byte[4];
                yield this.virtDriveSize;
            }
            case 1 -> {
                driveLabel = "Virtual".getBytes(StandardCharsets.UTF_8);
                driveLabelLen = Converters.intToArrLE(driveLabel.length);
                driveLetter = "HOME".getBytes(StandardCharsets.UTF_8);
                driveLetterLen = Converters.intToArrLE(driveLetter.length);
                File userHomeDir = new File(System.getProperty("user.home"));
                totalFreeSpace = Arrays.copyOfRange(Converters.longToArrLE(userHomeDir.getFreeSpace()), 0, 4);
                yield userHomeDir.getTotalSpace();
            }
            default -> {
                driveLabel = "Do not click (crashes Atmosphere)".getBytes(StandardCharsets.UTF_8);
                driveLabelLen = Converters.intToArrLE(driveLabel.length);
                driveLetter = "VIRT".getBytes(StandardCharsets.UTF_8);
                driveLetterLen = Converters.intToArrLE(driveLetter.length);
                totalFreeSpace = new byte[4];
                yield this.virtDriveSize;
            }
        }), 0, 4);
        List<byte[]> command = Arrays.asList(driveLabelLen, driveLabel, driveLetterLen, driveLetter, totalFreeSpace, totalSize);
        return this.writeGL_PASS(command, "GL Handle 'GetDriveInfo' command");
    }
}

