/*
 * Decompiled with CFR 0.152.
 */
package libKonogonka.fs.NPDM.ACID;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import libKonogonka.Converter;
import libKonogonka.fs.NPDM.ACID.FSAccessControlProvider;
import libKonogonka.fs.NPDM.KernelAccessControlProvider;
import libKonogonka.fs.NPDM.ServiceAccessControlProvider;

public class ACIDProvider {
    private final byte[] rsa2048signature;
    private final byte[] rsa2048publicKey;
    private final String magicNum;
    private final int dataSize;
    private final byte[] reserved1;
    private final byte flag1;
    private final byte flag2;
    private final byte flag3;
    private final byte flag4;
    private final long titleRangeMin;
    private final long titleRangeMax;
    private final int fsAccessControlOffset;
    private final int fsAccessControlSize;
    private final int serviceAccessControlOffset;
    private final int serviceAccessControlSize;
    private final int kernelAccessControlOffset;
    private final int kernelAccessControlSize;
    private final byte[] reserved2;
    private final FSAccessControlProvider fsAccessControlProvider;
    private final ServiceAccessControlProvider serviceAccessControlProvider;
    private final KernelAccessControlProvider kernelAccessControlProvider;

    public ACIDProvider(byte[] acidBytes) throws Exception {
        if (acidBytes.length < 576) {
            throw new Exception("ACIDProvider -> ACI0 size is too short");
        }
        this.rsa2048signature = Arrays.copyOfRange(acidBytes, 0, 256);
        this.rsa2048publicKey = Arrays.copyOfRange(acidBytes, 256, 512);
        this.magicNum = new String(acidBytes, 512, 4, StandardCharsets.UTF_8);
        this.dataSize = Converter.getLEint(acidBytes, 516);
        this.reserved1 = Arrays.copyOfRange(acidBytes, 520, 524);
        this.flag1 = acidBytes[524];
        this.flag2 = acidBytes[525];
        this.flag3 = acidBytes[526];
        this.flag4 = acidBytes[527];
        this.titleRangeMin = Converter.getLElong(acidBytes, 528);
        this.titleRangeMax = Converter.getLElong(acidBytes, 536);
        this.fsAccessControlOffset = Converter.getLEint(acidBytes, 544);
        this.fsAccessControlSize = Converter.getLEint(acidBytes, 548);
        this.serviceAccessControlOffset = Converter.getLEint(acidBytes, 552);
        this.serviceAccessControlSize = Converter.getLEint(acidBytes, 556);
        this.kernelAccessControlOffset = Converter.getLEint(acidBytes, 560);
        this.kernelAccessControlSize = Converter.getLEint(acidBytes, 564);
        this.reserved2 = Arrays.copyOfRange(acidBytes, 568, 576);
        if (this.fsAccessControlOffset > this.serviceAccessControlOffset || this.serviceAccessControlOffset > this.kernelAccessControlOffset) {
            throw new Exception("ACIDProvider -> blocks inside the ACID are not sorted in ascending order. Only ascending order supported.");
        }
        this.fsAccessControlProvider = new FSAccessControlProvider(Arrays.copyOfRange(acidBytes, this.fsAccessControlOffset, this.fsAccessControlOffset + this.fsAccessControlSize));
        this.serviceAccessControlProvider = new ServiceAccessControlProvider(Arrays.copyOfRange(acidBytes, this.serviceAccessControlOffset, this.serviceAccessControlOffset + this.serviceAccessControlSize));
        this.kernelAccessControlProvider = new KernelAccessControlProvider(Arrays.copyOfRange(acidBytes, this.kernelAccessControlOffset, this.kernelAccessControlOffset + this.kernelAccessControlSize));
    }

    public byte[] getRsa2048signature() {
        return this.rsa2048signature;
    }

    public byte[] getRsa2048publicKey() {
        return this.rsa2048publicKey;
    }

    public String getMagicNum() {
        return this.magicNum;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte getFlag1() {
        return this.flag1;
    }

    public byte getFlag2() {
        return this.flag2;
    }

    public byte getFlag3() {
        return this.flag3;
    }

    public byte getFlag4() {
        return this.flag4;
    }

    public long getTitleRangeMin() {
        return this.titleRangeMin;
    }

    public long getTitleRangeMax() {
        return this.titleRangeMax;
    }

    public int getFsAccessControlOffset() {
        return this.fsAccessControlOffset;
    }

    public int getFsAccessControlSize() {
        return this.fsAccessControlSize;
    }

    public int getServiceAccessControlOffset() {
        return this.serviceAccessControlOffset;
    }

    public int getServiceAccessControlSize() {
        return this.serviceAccessControlSize;
    }

    public int getKernelAccessControlOffset() {
        return this.kernelAccessControlOffset;
    }

    public int getKernelAccessControlSize() {
        return this.kernelAccessControlSize;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public FSAccessControlProvider getFsAccessControlProvider() {
        return this.fsAccessControlProvider;
    }

    public ServiceAccessControlProvider getServiceAccessControlProvider() {
        return this.serviceAccessControlProvider;
    }

    public KernelAccessControlProvider getKernelAccessControlProvider() {
        return this.kernelAccessControlProvider;
    }
}

