/*
 * Decompiled with CFR 0.152.
 */
package nsusbloader.com.net;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import nsusbloader.ModelControllers.CancellableRunnable;
import nsusbloader.ModelControllers.ILogPrinter;
import nsusbloader.ModelControllers.Log;
import nsusbloader.NSLDataTypes.EFileStatus;
import nsusbloader.NSLDataTypes.EModule;
import nsusbloader.NSLDataTypes.EMsgType;
import nsusbloader.com.helpers.NSSplitReader;
import nsusbloader.com.net.NETPacket;
import nsusbloader.com.net.NetworkSetupValidator;
import nsusbloader.com.net.UniFile;

public class NETCommunications
extends CancellableRunnable {
    private final ILogPrinter logPrinter;
    private final String switchIP;
    private static final int SWITCH_PORT = 2000;
    private final String hostIP;
    private final int hostPort;
    private final String extras;
    private final boolean doNotServe;
    private final HashMap<String, UniFile> files;
    private final ServerSocket serverSocket;
    private Socket clientSocket;
    private final boolean isValid;
    private OutputStream currSockOS;
    private PrintWriter currSockPW;
    private boolean jobInProgress = true;

    public NETCommunications(List<File> filesList, String switchIP, boolean doNotServe, String hostIP, String hostPortNum, String extras) {
        this.doNotServe = doNotServe;
        this.extras = doNotServe ? extras : "";
        this.switchIP = switchIP;
        this.logPrinter = Log.getPrinter(EModule.USB_NET_TRANSFERS);
        NetworkSetupValidator validator = new NetworkSetupValidator(filesList, doNotServe, hostIP, hostPortNum, this.logPrinter);
        this.hostIP = validator.getHostIP();
        this.hostPort = validator.getHostPort();
        this.files = validator.getFiles();
        this.serverSocket = validator.getServerSocket();
        this.isValid = validator.isValid();
        if (!this.isValid) {
            this.close(EFileStatus.FAILED);
        }
    }

    @Override
    public void run() {
        if (!this.isValid || this.isCancelled()) {
            return;
        }
        this.print("\tStart chain", EMsgType.INFO);
        String handshakeContent = this.buildHandshakeContent();
        byte[] handshakeCommand = handshakeContent.getBytes(StandardCharsets.UTF_8);
        byte[] handshakeCommandSize = ByteBuffer.allocate(4).putInt(handshakeCommand.length).array();
        if (this.sendHandshake(handshakeCommandSize, handshakeCommand)) {
            return;
        }
        if (this.doNotServe) {
            this.print("List of files transferred. Replies won't be served.", EMsgType.PASS);
            this.close(EFileStatus.UNKNOWN);
            return;
        }
        this.print("Initiation files list has been sent to NS.", EMsgType.PASS);
        this.serveRequestsLoop();
    }

    private String buildHandshakeContent() {
        StringBuilder builder = new StringBuilder();
        for (String fileNameEncoded : this.files.keySet()) {
            builder.append(this.hostIP);
            builder.append(':');
            builder.append(this.hostPort);
            builder.append('/');
            builder.append(this.extras);
            builder.append(fileNameEncoded);
            builder.append('\n');
        }
        return builder.toString();
    }

    private boolean sendHandshake(byte[] handshakeCommandSize, byte[] handshakeCommand) {
        try {
            Socket handshakeSocket = new Socket(InetAddress.getByName(this.switchIP), 2000);
            OutputStream os = handshakeSocket.getOutputStream();
            os.write(handshakeCommandSize);
            os.write(handshakeCommand);
            os.flush();
            handshakeSocket.close();
        }
        catch (IOException uhe) {
            this.print("Unable to connect to NS and send files list:\n         " + uhe.getMessage(), EMsgType.FAIL);
            this.close(EFileStatus.UNKNOWN);
            return true;
        }
        return false;
    }

    private void serveRequestsLoop() {
        try {
            while (this.jobInProgress) {
                String line;
                this.clientSocket = this.serverSocket.accept();
                BufferedReader br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                this.currSockOS = this.clientSocket.getOutputStream();
                this.currSockPW = new PrintWriter(new OutputStreamWriter(this.currSockOS));
                LinkedList<String> tcpPacket = new LinkedList<String>();
                while ((line = br.readLine()) != null) {
                    if (line.trim().isEmpty()) {
                        this.handleRequest(tcpPacket);
                        tcpPacket.clear();
                        continue;
                    }
                    tcpPacket.add(line);
                }
                this.clientSocket.close();
            }
        }
        catch (Exception e) {
            if (this.isCancelled()) {
                this.print("Interrupted by user.", EMsgType.INFO);
            } else {
                this.print(e.getMessage(), EMsgType.INFO);
            }
            this.close(EFileStatus.UNKNOWN);
            return;
        }
        this.print("All transfers complete", EMsgType.PASS);
        this.close(EFileStatus.UPLOADED);
    }

    private void handleRequest(LinkedList<String> packet) throws Exception {
        if (packet.get(0).startsWith("DROP")) {
            this.jobInProgress = false;
            return;
        }
        String reqFileName = packet.get(0).replaceAll("(^[A-z\\s]+/)|(\\s+?.*$)", "");
        if (!this.files.containsKey(reqFileName)) {
            this.writeToSocket(NETPacket.getCode404());
            this.print("File " + reqFileName + " doesn't exists or have 0 size. Returning 404", EMsgType.FAIL);
            return;
        }
        long reqFileSize = this.files.get(reqFileName).getSize();
        File requestedFile = this.files.get(reqFileName).getFile();
        if (!requestedFile.exists() || reqFileSize == 0L) {
            this.writeToSocket(NETPacket.getCode404());
            this.print("File " + requestedFile.getName() + " doesn't exists or have 0 size. Returning 404", EMsgType.FAIL);
            this.logPrinter.update(requestedFile, EFileStatus.FAILED);
            return;
        }
        if (packet.get(0).startsWith("HEAD")) {
            this.writeToSocket(NETPacket.getCode200(reqFileSize));
            this.print("Replying for requested file: " + requestedFile.getName(), EMsgType.INFO);
            return;
        }
        if (packet.get(0).startsWith("GET")) {
            for (String line : packet) {
                if (!line.toLowerCase().startsWith("range")) continue;
                this.parseGETrange(requestedFile, reqFileName, reqFileSize, line);
                return;
            }
        }
    }

    private void parseGETrange(File file, String fileName, long fileSize, String rangeDirective) throws Exception {
        try {
            String[] rangeStr = rangeDirective.toLowerCase().replaceAll("^range:\\s+?bytes=", "").split("-", 2);
            if (!rangeStr[0].isEmpty() && !rangeStr[1].isEmpty()) {
                long toRange;
                long fromRange = Long.parseLong(rangeStr[0]);
                if (fromRange > (toRange = Long.parseLong(rangeStr[1]))) {
                    this.writeToSocket(NETPacket.getCode400());
                    this.print("Requested range for " + file.getName() + " is incorrect. Returning 400", EMsgType.FAIL);
                    this.logPrinter.update(file, EFileStatus.FAILED);
                    return;
                }
                this.writeToSocket(fileName, fromRange, toRange);
                return;
            }
            if (!rangeStr[0].isEmpty()) {
                this.writeToSocket(fileName, Long.parseLong(rangeStr[0]), fileSize);
                return;
            }
            if (rangeStr[1].isEmpty()) {
                this.writeToSocket(NETPacket.getCode400());
                this.print("Requested range for " + file.getName() + " is incorrect (empty start & end). Returning 400", EMsgType.FAIL);
                this.logPrinter.update(file, EFileStatus.FAILED);
                return;
            }
            if (fileSize > 500L) {
                this.writeToSocket(fileName, fileSize - 500L, fileSize);
                return;
            }
            this.writeToSocket(NETPacket.getCode416());
            this.print("File size requested for " + file.getName() + " while actual size of it: " + fileSize + ". Returning 416", EMsgType.FAIL);
            this.logPrinter.update(file, EFileStatus.FAILED);
        }
        catch (NumberFormatException nfe) {
            this.writeToSocket(NETPacket.getCode400());
            this.print("Requested range for " + file.getName() + " has incorrect format. Returning 400\n\t" + nfe.getMessage(), EMsgType.FAIL);
            this.logPrinter.update(file, EFileStatus.FAILED);
        }
    }

    private void writeToSocket(String string) {
        this.currSockPW.write(string);
        this.currSockPW.flush();
    }

    private void writeToSocket(String fileName, long start, long end) throws Exception {
        File file = this.files.get(fileName).getFile();
        this.print("Reply to range: " + start + "-" + end, EMsgType.INFO);
        this.writeToSocket(NETPacket.getCode206(this.files.get(fileName).getSize(), start, end));
        try {
            if (file.isDirectory()) {
                this.handleSplitFile(file, start, end);
            } else {
                this.handleRegularFile(file, start, end);
            }
            this.logPrinter.updateProgress(1.0);
        }
        catch (Exception e) {
            this.logPrinter.update(file, EFileStatus.FAILED);
            throw new Exception("File transmission failed:\n         " + e.getMessage());
        }
    }

    private void handleSplitFile(File file, long start, long end) throws Exception {
        long count = end - start + 1L;
        int readPice = 1024;
        NSSplitReader nsr = new NSSplitReader(file, start);
        for (long currentOffset = 0L; currentOffset < count; currentOffset += (long)readPice) {
            byte[] byteBuf;
            if (currentOffset + (long)readPice >= count) {
                readPice = Math.toIntExact(count - currentOffset);
            }
            if (nsr.read(byteBuf = new byte[readPice]) != readPice) {
                throw new IOException("File stream suddenly ended.");
            }
            this.currSockOS.write(byteBuf);
            this.logPrinter.updateProgress((double)(currentOffset + (long)readPice) / ((double)count / 100.0) / 100.0);
        }
        this.currSockOS.flush();
        nsr.close();
    }

    private void handleRegularFile(File file, long start, long end) throws Exception {
        long count = end - start + 1L;
        int readPice = 1024;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        if (bis.skip(start) != start) {
            throw new IOException("Unable to skip requested range.");
        }
        for (long currentOffset = 0L; currentOffset < count; currentOffset += (long)readPice) {
            byte[] byteBuf;
            if (currentOffset + (long)readPice >= count) {
                readPice = Math.toIntExact(count - currentOffset);
            }
            if (bis.read(byteBuf = new byte[readPice]) != readPice) {
                throw new IOException("File stream suddenly ended.");
            }
            this.currSockOS.write(byteBuf);
            this.logPrinter.updateProgress((double)(currentOffset + (long)readPice) / ((double)count / 100.0) / 100.0);
        }
        this.currSockOS.flush();
        bis.close();
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public Socket getClientSocket() {
        return this.clientSocket;
    }

    private void close(EFileStatus status) {
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
                this.print("Closing server socket.", EMsgType.PASS);
            }
        }
        catch (IOException ioe) {
            this.print("Closing server socket failed. Sometimes it's not an issue.", EMsgType.WARNING);
        }
        HashMap<String, File> tempMap = new HashMap<String, File>();
        for (UniFile sf : this.files.values()) {
            tempMap.put(sf.getFile().getName(), sf.getFile());
        }
        this.logPrinter.update(tempMap, status);
        this.print("\tEnd chain", EMsgType.INFO);
        this.logPrinter.close();
    }

    private void print(String message, EMsgType type) {
        try {
            this.logPrinter.print(message, type);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

